/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.util;

import com.the9grounds.aeadditions.integration.Mods;
import com.the9grounds.aeadditions.util.ChannelInfo;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty1;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J?\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/the9grounds/aeadditions/util/ChannelInfo;", "", "id", "Ljava/util/UUID;", "name", "", "isPrivate", "", "creator", "creatorName", "<init>", "(Ljava/util/UUID;Ljava/lang/String;ZLjava/util/UUID;Ljava/lang/String;)V", "getId", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "()Z", "getCreator", "getCreatorName", "creatorCodec", "Ljava/util/Optional;", "getCreatorCodec", "()Ljava/util/Optional;", "creatorNameCodec", "getCreatorNameCodec", "equals", "other", "hashCode", "", "saveToNbt", "Lnet/minecraft/nbt/CompoundTag;", "hasAccessTo", "player", "Lnet/minecraft/server/level/ServerPlayer;", "hasAccessToDelete", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "Companion", "AEAdditions-1.21.1-6.0.2"})
public final class ChannelInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private final String name;
    private final boolean isPrivate;
    @Nullable
    private final UUID creator;
    @Nullable
    private final String creatorName;
    private static final StreamCodec<ByteBuf, ChannelInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, arg_0 -> ChannelInfo.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.STRING_UTF8, arg_0 -> ChannelInfo.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> ChannelInfo.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), arg_0 -> ChannelInfo.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.4.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), arg_0 -> ChannelInfo.STREAM_CODEC$lambda$4((KProperty1)Companion.STREAM_CODEC.5.INSTANCE, arg_0), Companion::fromCodec);

    public ChannelInfo(@NotNull UUID id, @NotNull String name, boolean isPrivate, @Nullable UUID creator, @Nullable String creatorName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
        this.isPrivate = isPrivate;
        this.creator = creator;
        this.creatorName = creatorName;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    @Nullable
    public final UUID getCreator() {
        return this.creator;
    }

    @Nullable
    public final String getCreatorName() {
        return this.creatorName;
    }

    @NotNull
    public final Optional<UUID> getCreatorCodec() {
        Optional<UUID> optional = Optional.ofNullable(this.creator);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<String> getCreatorNameCodec() {
        Optional<String> optional = Optional.ofNullable(this.creatorName);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ChannelInfo && Intrinsics.areEqual((Object)this.id, (Object)((ChannelInfo)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final CompoundTag saveToNbt() {
        CompoundTag channelInfoTag = new CompoundTag();
        channelInfoTag.putBoolean("isPrivate", this.isPrivate);
        channelInfoTag.putString("name", this.name);
        channelInfoTag.putString("id", this.id.toString());
        channelInfoTag.putString("playerUUID", String.valueOf(this.creator));
        channelInfoTag.putString("playerName", this.creatorName);
        return channelInfoTag;
    }

    public final boolean hasAccessTo(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isPrivate) {
            return true;
        }
        if (Mods.FTBTEAMS.isEnabled()) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(this.creator, player.getUUID());
        }
        return Intrinsics.areEqual((Object)this.creator, (Object)player.getUUID());
    }

    public final boolean hasAccessToDelete(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Mods.FTBTEAMS.isEnabled()) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(this.creator, player.getUUID());
        }
        return Intrinsics.areEqual((Object)this.creator, (Object)player.getUUID());
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final boolean component3() {
        return this.isPrivate;
    }

    @Nullable
    public final UUID component4() {
        return this.creator;
    }

    @Nullable
    public final String component5() {
        return this.creatorName;
    }

    @NotNull
    public final ChannelInfo copy(@NotNull UUID id, @NotNull String name, boolean isPrivate, @Nullable UUID creator, @Nullable String creatorName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ChannelInfo(id, name, isPrivate, creator, creatorName);
    }

    public static /* synthetic */ ChannelInfo copy$default(ChannelInfo channelInfo, UUID uUID, String string, boolean bl, UUID uUID2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = channelInfo.id;
        }
        if ((n & 2) != 0) {
            string = channelInfo.name;
        }
        if ((n & 4) != 0) {
            bl = channelInfo.isPrivate;
        }
        if ((n & 8) != 0) {
            uUID2 = channelInfo.creator;
        }
        if ((n & 0x10) != 0) {
            string2 = channelInfo.creatorName;
        }
        return channelInfo.copy(uUID, string, bl, uUID2, string2);
    }

    @NotNull
    public String toString() {
        return "ChannelInfo(id=" + this.id + ", name=" + this.name + ", isPrivate=" + this.isPrivate + ", creator=" + this.creator + ", creatorName=" + this.creatorName + ")";
    }

    private static final UUID STREAM_CODEC$lambda$0(KProperty1 $tmp0, ChannelInfo p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UUID)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final String STREAM_CODEC$lambda$1(KProperty1 $tmp0, ChannelInfo p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean STREAM_CODEC$lambda$2(KProperty1 $tmp0, ChannelInfo p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional STREAM_CODEC$lambda$3(KProperty1 $tmp0, ChannelInfo p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional STREAM_CODEC$lambda$4(KProperty1 $tmp0, ChannelInfo p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018RS\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/the9grounds/aeadditions/util/ChannelInfo$Companion;", "", "<init>", "()V", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "Lcom/the9grounds/aeadditions/util/ChannelInfo;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/codec/StreamCodec;", "fromCodec", "id", "Ljava/util/UUID;", "name", "", "isPrivate", "", "creator", "Ljava/util/Optional;", "creatorName", "readFromNbt", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "AEAdditions-1.21.1-6.0.2"})
    public static final class Companion {
        private Companion() {
        }

        public final StreamCodec<ByteBuf, ChannelInfo> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @NotNull
        public final ChannelInfo fromCodec(@NotNull UUID id, @NotNull String name, boolean isPrivate, @NotNull Optional<UUID> creator, @NotNull Optional<String> creatorName) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(creator, (String)"creator");
            Intrinsics.checkNotNullParameter(creatorName, (String)"creatorName");
            return new ChannelInfo(id, name, isPrivate, (UUID)OptionalsKt.getOrNull(creator), (String)OptionalsKt.getOrNull(creatorName));
        }

        @NotNull
        public final ChannelInfo readFromNbt(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            boolean isPrivate = nbt.getBoolean("isPrivate");
            String creatorName = null;
            creatorName = nbt.getString("playerName");
            UUID creator = UUID.fromString(nbt.getString("playerUUID"));
            UUID uUID = UUID.fromString(nbt.getString("id"));
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            String string = nbt.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return new ChannelInfo(uUID, string, isPrivate, creator, creatorName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

