/*
 * Decompiled with CFR 0.152.
 */
package com.keshavxd_.playerfinder.command;

import com.keshavxd_.playerfinder.config.PlayerFinderConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class PlayerFinderClientCommands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pfcolor").then(ClientCommandManager.argument((String)"hex", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String arg = StringArgumentType.getString((CommandContext)ctx, (String)"hex");
            Integer rgb = PlayerFinderClientCommands.parseColor(arg);
            FabricClientCommandSource src = (FabricClientCommandSource)ctx.getSource();
            if (rgb == null) {
                src.sendError((class_2561)class_2561.method_43470((String)"Invalid color. Use #RRGGBB or a color name."));
                return 0;
            }
            PlayerFinderConfig.getInstance().setTextColor(rgb);
            src.sendFeedback((class_2561)class_2561.method_43470((String)"Player Finder color set."));
            return 1;
        }))).executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Usage: /pfcolor <#RRGGBB|name>"));
            return 1;
        })));
    }

    private static Integer parseHex(String s) {
        try {
            String t;
            String string = t = s.startsWith("#") ? s.substring(1) : s;
            if (t.length() != 6) {
                return null;
            }
            int r = Integer.parseInt(t.substring(0, 2), 16);
            int g = Integer.parseInt(t.substring(2, 4), 16);
            int b = Integer.parseInt(t.substring(4, 6), 16);
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer parseName(String s) {
        String k;
        switch (k = s.toLowerCase()) {
            case "red": {
                return -65536;
            }
            case "green": {
                return -16711936;
            }
            case "blue": {
                return -16776961;
            }
            case "yellow": {
                return -256;
            }
            case "white": {
                return -1;
            }
            case "black": {
                return -16777216;
            }
            case "cyan": {
                return -16711681;
            }
            case "magenta": {
                return -65281;
            }
            case "purple": {
                return -8388480;
            }
            case "orange": {
                return -23296;
            }
            case "pink": {
                return -16181;
            }
            case "gray": {
                return -8355712;
            }
            case "lightgray": {
                return -2894893;
            }
            case "lime": {
                return -13447886;
            }
        }
        return null;
    }

    private static Integer parseColor(String s) {
        Integer byHex = PlayerFinderClientCommands.parseHex(s);
        if (byHex != null) {
            return byHex;
        }
        return PlayerFinderClientCommands.parseName(s);
    }
}

