/*
 * Decompiled with CFR 0.152.
 */
package com.keshavxd_.playerfinder.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.keshavxd_.playerfinder.PlayerFinder;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class PlayerFinderConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("player-finder.json").toFile();
    private static PlayerFinderConfig instance;
    private int textColor = Color.RED.getRGB();

    public static PlayerFinderConfig getInstance() {
        if (instance == null) {
            PlayerFinderConfig.load();
        }
        return instance;
    }

    public static void load() {
        block8: {
            try {
                if (CONFIG_FILE.exists()) {
                    try (FileReader reader = new FileReader(CONFIG_FILE);){
                        instance = (PlayerFinderConfig)GSON.fromJson((Reader)reader, PlayerFinderConfig.class);
                        break block8;
                    }
                }
                instance = new PlayerFinderConfig();
                PlayerFinderConfig.save();
            }
            catch (IOException e) {
                PlayerFinder.LOGGER.error("Failed to load config", (Throwable)e);
                instance = new PlayerFinderConfig();
            }
        }
    }

    public static void save() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)instance, (Appendable)writer);
            }
        }
        catch (IOException e) {
            PlayerFinder.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        PlayerFinderConfig.save();
    }
}

