/*
 * Decompiled with CFR 0.152.
 */
package com.keshavxd_.playerfinder.hud;

import com.keshavxd_.playerfinder.PlayerFinderClient;
import com.keshavxd_.playerfinder.config.PlayerFinderConfig;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class NearestPlayerHud {
    private static final class_310 CLIENT = class_310.method_1551();

    public void render(class_332 context, float tickDelta) {
        if (CLIENT == null || NearestPlayerHud.CLIENT.field_1724 == null || NearestPlayerHud.CLIENT.field_1687 == null || NearestPlayerHud.CLIENT.field_1690.field_1842) {
            return;
        }
        if (!PlayerFinderClient.isEnabled()) {
            return;
        }
        class_746 player = NearestPlayerHud.CLIENT.field_1724;
        class_1657 nearestPlayer = this.findNearestPlayer((class_1657)player);
        if (nearestPlayer == null) {
            return;
        }
        if (nearestPlayer.method_5715()) {
            return;
        }
        double distance = player.method_19538().method_1022(nearestPlayer.method_19538());
        String direction = this.getDirection((class_1657)player, nearestPlayer);
        String displayTextStr = String.format("\u00a7l%s \u00a7r(%.1f blocks, %s)", nearestPlayer.method_5477().getString(), distance, direction);
        class_5250 displayText = class_2561.method_43470((String)displayTextStr);
        int width = CLIENT.method_22683().method_4486();
        int height = CLIENT.method_22683().method_4502();
        class_327 textRenderer = NearestPlayerHud.CLIENT.field_1772;
        int textWidth = textRenderer.method_1727(displayTextStr);
        int x = width / 2 - textWidth / 2;
        int y = height - this.getHudOffset();
        int textColor = PlayerFinderConfig.getInstance().getTextColor();
        context.method_51439(textRenderer, (class_2561)displayText, x, y, textColor, true);
    }

    private class_1657 findNearestPlayer(class_1657 player) {
        if (NearestPlayerHud.CLIENT.field_1687 == null) {
            return null;
        }
        List players = NearestPlayerHud.CLIENT.field_1687.method_18456().stream().filter(p -> p != player && !p.method_31481() && !p.method_5767() && p.method_5805()).collect(Collectors.toList());
        if (players.isEmpty()) {
            return null;
        }
        return players.stream().min(Comparator.comparingDouble(p -> p.method_5858((class_1297)player))).orElse(null);
    }

    private String getDirection(class_1657 from, class_1657 to) {
        class_243 fromPos = from.method_19538();
        class_243 toPos = to.method_19538();
        double dx = toPos.field_1352 - fromPos.field_1352;
        double dz = toPos.field_1350 - fromPos.field_1350;
        double angle = Math.toDegrees(Math.atan2(dz, dx)) - (double)from.method_36454();
        if ((angle = (angle % 360.0 + 360.0) % 360.0) < 22.5 || angle >= 337.5) {
            return "\u2190";
        }
        if (angle < 67.5) {
            return "\u2196";
        }
        if (angle < 112.5) {
            return "\u2191";
        }
        if (angle < 157.5) {
            return "\u2197";
        }
        if (angle < 202.5) {
            return "\u2192";
        }
        if (angle < 247.5) {
            return "\u2198";
        }
        if (angle < 292.5) {
            return "\u2193";
        }
        if (angle < 337.5) {
            return "\u2199";
        }
        return "?";
    }

    private int getHudOffset() {
        return 59;
    }
}

