/*
 * Decompiled with CFR 0.152.
 */
package cafe.tilde.winter.custom_login;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class LoginServerMotdSequence {
    private final MetaFileLocation metaFileLocation;
    private final boolean loginRequired;

    public LoginServerMotdSequence(String sequence) {
        assert (sequence.length() == 4);
        this.metaFileLocation = MetaFileLocation.fromCode(sequence.charAt(1));
        this.loginRequired = sequence.charAt(3) == '1';
    }

    public MetaFileLocation getMetaFileLocation() {
        return this.metaFileLocation;
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public URL getMetaFileURL(String serverAddress) {
        String secondLevelDomain;
        String[] domainParts = serverAddress.split("\\.");
        try {
            secondLevelDomain = String.join((CharSequence)".", Arrays.copyOfRange(domainParts, domainParts.length - 3, domainParts.length - 1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            secondLevelDomain = "";
        }
        try {
            return new URL(switch (this.metaFileLocation) {
                default -> throw new IncompatibleClassChangeError();
                case MetaFileLocation.HTTP_CURRENT_HOST -> String.format("http://%s/.well-known/yggdrasil.json", serverAddress);
                case MetaFileLocation.HTTPS_CURRENT_HOST -> String.format("https://%s/.well-known/yggdrasil.json", serverAddress);
                case MetaFileLocation.HTTP_WWW_HOST -> String.format("http://www.%s/.well-known/yggdrasil.json", secondLevelDomain);
                case MetaFileLocation.HTTPS_WWW_HOST -> String.format("https://www.%s/.well-known/yggdrasil.json", secondLevelDomain);
                case MetaFileLocation.HTTP_DEDICATED_HOST -> String.format("http://ygg.%s/meta.json", secondLevelDomain);
                case MetaFileLocation.HTTPS_DEDICATED_HOST -> String.format("https://ygg.%s/meta.json", secondLevelDomain);
                case MetaFileLocation.ASK_FOR_FILE, MetaFileLocation.ASK_FOR_ENDPOINTS -> "";
            });
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }

    public static enum MetaFileLocation {
        HTTP_CURRENT_HOST('0'),
        HTTPS_CURRENT_HOST('1'),
        HTTP_WWW_HOST('2'),
        HTTPS_WWW_HOST('3'),
        HTTP_DEDICATED_HOST('4'),
        HTTPS_DEDICATED_HOST('5'),
        ASK_FOR_FILE('e'),
        ASK_FOR_ENDPOINTS('f');

        private final char code;

        private MetaFileLocation(char code) {
            this.code = code;
        }

        public static MetaFileLocation fromCode(char code) {
            for (MetaFileLocation location : MetaFileLocation.values()) {
                if (location.code != code) continue;
                return location;
            }
            return null;
        }
    }
}

