/*
 * Decompiled with CFR 0.152.
 */
package cafe.tilde.winter.custom_login.gui;

import cafe.tilde.winter.custom_login.gui.LoginScreen;
import cafe.tilde.winter.custom_login.util.LoginServerMotdSequence;
import cafe.tilde.winter.custom_login.util.YggdrasilMetadata;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_642;

public class FetchLoginInfoScreen
extends class_437 {
    private final class_437 parent;
    private final LoginServerMotdSequence motdSequence;
    private final class_642 entry;
    private class_2561 displayedTitle;
    private boolean hasAskForFileWidgets;

    public FetchLoginInfoScreen(class_437 parent, LoginServerMotdSequence motdSequence, class_642 entry) {
        super((class_2561)new class_2588("gui.custom_login.fetching.title"));
        this.parent = parent;
        this.motdSequence = motdSequence;
        this.entry = entry;
        this.displayedTitle = this.field_22785;
        this.hasAskForFileWidgets = false;
    }

    public void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        URL metaFileURL = this.motdSequence.getMetaFileURL(this.entry.field_3761);
        if (metaFileURL == null) {
            this.displayedTitle = new class_2588("gui.custom_login.fetching.ask.title");
            if (this.motdSequence.getMetaFileLocation() == LoginServerMotdSequence.MetaFileLocation.ASK_FOR_FILE) {
                this.addAskForFileWidgets();
            } else {
                this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)new class_2588("gui.custom_login.error.title"), (class_2561)new class_2588("gui.custom_login.nyi.description")));
                this.field_22787.method_1507(this.parent);
            }
            return;
        }
        this.fetchAndContinue(metaFileURL);
    }

    private void fetchAndContinue(URL metaFileURL) {
        block3: {
            assert (this.field_22787 != null);
            Gson gson = new Gson();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(metaFileURL.toURI()).header("Accept", "application/json").GET().build();
                ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                    String jsonString = (String)response.body();
                    YggdrasilMetadata metadata = (YggdrasilMetadata)gson.fromJson(jsonString, YggdrasilMetadata.class);
                    this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new LoginScreen(this.parent, metadata, this.entry)));
                })).exceptionally(error -> {
                    this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)new class_2588("gui.custom_login.error.title"), (class_2561)new class_2585(error.getLocalizedMessage())));
                    if (!this.hasAskForFileWidgets) {
                        this.field_22787.method_1507(this.parent);
                    }
                    return null;
                });
            }
            catch (URISyntaxException ex) {
                this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)new class_2588("gui.custom_login.error.title"), (class_2561)new class_2585(ex.getLocalizedMessage())));
                if (this.hasAskForFileWidgets) break block3;
                this.field_22787.field_1774.method_1462(false);
                this.field_22787.method_1507(this.parent);
            }
        }
    }

    private void addAskForFileWidgets() {
        if (!this.hasAskForFileWidgets) {
            this.hasAskForFileWidgets = true;
            assert (this.field_22787 != null);
            this.field_22787.field_1774.method_1462(true);
            class_342 fileLocationField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 100, this.field_22790 / 2 - 21, 200, 20, (class_2561)new class_2588("gui.custom_login.fetching.ask.meta_file")));
            fileLocationField.method_1880(256);
            this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 100, this.field_22790 / 2 + 1, 100, 20, (class_2561)new class_2588("gui.ok"), button -> {
                try {
                    URL metaFileURL = new URL(fileLocationField.method_1882());
                    this.fetchAndContinue(metaFileURL);
                }
                catch (MalformedURLException e) {
                    this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)new class_2588("gui.custom_login.error.title"), (class_2561)new class_2585(e.getLocalizedMessage())));
                }
            }));
            this.method_37063((class_364)new class_4185(this.field_22789 / 2, this.field_22790 / 2 + 1, 100, 20, (class_2561)new class_2588("gui.cancel"), button -> {
                this.field_22787.field_1774.method_1462(false);
                this.field_22787.method_1507(this.parent);
            }));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        FetchLoginInfoScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.displayedTitle, (int)(this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        if (this.hasAskForFileWidgets) {
            FetchLoginInfoScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588("gui.custom_login.fetching.ask.description"), (int)(this.field_22789 / 2), (int)40, (int)0xAAAAAA);
            FetchLoginInfoScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588("gui.custom_login.fetching.ask.meta_file"), (int)(this.field_22789 / 2 - 100), (int)(this.field_22790 / 2 - 30), (int)0xFFFFFF);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }
}

