/*
 * Decompiled with CFR 0.152.
 */
package com.lonkachu.stackable;

import com.lonkachu.stackable.StackableMod;
import com.lonkachu.stackable.StacksizeOverride;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.GatherComponentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="stackable")
public class Stackable {
    public Stackable(FMLJavaModLoadingContext ctx) {
        StackableMod.init();
        BusGroup modBus = ctx.getModBusGroup();
        GatherComponentsEvent.Item.BUS.addListener(this::RegistryEvent);
    }

    public void RegistryEvent(GatherComponentsEvent.Item event) {
        Item i = event.getOwner();
        for (StacksizeOverride override : StackableMod.GetConfig().GetOverrides()) {
            Optional optional = BuiltInRegistries.ITEM.get(override.GetIdentifier());
            if (optional.isEmpty()) {
                StackableMod.LOGGER.error("No such block exists with the key " + String.valueOf(override.GetIdentifier()) + " skipping stack size modification!!!");
                continue;
            }
            Item p = (Item)((Holder.Reference)optional.get()).value();
            if (i != p) continue;
            event.register(DataComponents.MAX_STACK_SIZE, (Object)override.GetCount());
        }
    }
}

