/*
 * Decompiled with CFR 0.152.
 */
package industries._5505.quic_protocol_support.quic;

import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.Blake3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lindustries/_5505/quic_protocol_support/quic/Blake3ConnectionIdGenerator;", "Lio/netty/incubator/codec/quic/QuicConnectionIdGenerator;", "", "key", "<init>", "([B)V", "", "length", "Ljava/nio/ByteBuffer;", "newId", "(I)Ljava/nio/ByteBuffer;", "input", "(Ljava/nio/ByteBuffer;I)Ljava/nio/ByteBuffer;", "maxConnectionIdLength", "()I", "", "isIdempotent", "()Z", "Lorg/apache/commons/codec/digest/Blake3;", "kotlin.jvm.PlatformType", "hash", "Lorg/apache/commons/codec/digest/Blake3;", "QuicProtocolSupport"})
@SourceDebugExtension(value={"SMAP\nBlake3ConnectionIdGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Blake3ConnectionIdGenerator.kt\nindustries/_5505/quic_protocol_support/quic/Blake3ConnectionIdGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class Blake3ConnectionIdGenerator
implements QuicConnectionIdGenerator {
    private final Blake3 hash;

    public Blake3ConnectionIdGenerator(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.hash = Blake3.initKeyedHash((byte[])key);
    }

    @NotNull
    public ByteBuffer newId(int length) {
        throw new UnsupportedOperationException("must always have an input");
    }

    @NotNull
    public ByteBuffer newId(@NotNull ByteBuffer input, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(length > 0)) {
            boolean $i$a$-require-Blake3ConnectionIdGenerator$newId$32 = false;
            String $i$a$-require-Blake3ConnectionIdGenerator$newId$32 = "length: " + length + " (expected: > 0)";
            throw new IllegalArgumentException($i$a$-require-Blake3ConnectionIdGenerator$newId$32.toString());
        }
        if (!(0 <= length ? length <= this.maxConnectionIdLength() : false)) {
            boolean bl = false;
            String string = "length: " + length + " (expected: 0-" + this.maxConnectionIdLength() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.hash.reset();
        if (input.hasArray()) {
            v0 = this.hash.update(input.array(), input.arrayOffset() + input.position(), input.remaining());
        } else {
            byte[] buffer = new byte[input.remaining()];
            input.get(buffer);
            v0 = this.hash.update(buffer);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.hash.doFinalize(length));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    public int maxConnectionIdLength() {
        return 20;
    }

    public boolean isIdempotent() {
        return true;
    }
}

