/*
 * Decompiled with CFR 0.152.
 */
package industries._5505.quic_protocol_support;

import industries._5505.quic_protocol_support.mixin.ClientConnectionAccessor;
import industries._5505.quic_protocol_support.quic.Blake3ConnectionIdGenerator;
import industries._5505.quic_protocol_support.quic.Blake3TokenHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.QuicPathEvent;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2598;
import net.minecraft.class_3176;
import net.minecraft.class_3246;
import net.minecraft.class_5472;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a9\u0010\n\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\n\u0010\u000b\"\u0014\u0010\r\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\"\u0014\u0010\u0010\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\"\u001c\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lnet/minecraft/class_3176;", "server", "Ljava/net/InetSocketAddress;", "socketAddress", "", "Lio/netty/channel/ChannelFuture;", "channels", "Lnet/minecraft/class_2535;", "connections", "", "startQuicListener", "(Lnet/minecraft/class_3176;Ljava/net/InetSocketAddress;Ljava/util/List;Ljava/util/List;)V", "", "APPLICATION_PROTOCOL", "Ljava/lang/String;", "", "MAX_DATA", "J", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "QuicProtocolSupport"})
@JvmName(name="QuicListener")
@SourceDebugExtension(value={"SMAP\nQuicListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicListener.kt\nindustries/_5505/quic_protocol_support/QuicListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class QuicListener {
    @NotNull
    public static final String APPLICATION_PROTOCOL = "minecraft";
    public static final long MAX_DATA = 0x800000L;
    private static final Logger logger = LogManager.getLogger();

    public static final void startQuicListener(@NotNull class_3176 server, @NotNull InetSocketAddress socketAddress, @NotNull List<ChannelFuture> channels, @NotNull List<class_2535> connections) {
        byte[] p0;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(connections, (String)"connections");
        boolean useEpoll = Epoll.isAvailable() && server.method_3759();
        Path config = FabricLoader.getInstance().getConfigDir().resolve("quic");
        File keyFile = config.resolve("key.pem").toFile();
        File certificateFile = config.resolve("certificate.pem").toFile();
        if (!keyFile.exists() || !certificateFile.exists()) {
            logger.error("TLS key or certificate not found; make sure that it is in the right place");
            return;
        }
        String[] stringArray = new String[]{APPLICATION_PROTOCOL};
        QuicSslContext context = QuicSslContextBuilder.forServer((File)keyFile, null, (File)certificateFile).applicationProtocols(stringArray).build();
        WeakHashMap<Channel, SocketAddress> parentChannelAddresses = new WeakHashMap<Channel, SocketAddress>();
        byte[] byArray = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = byArray;
        QuicServerCodecBuilder quicServerCodecBuilder = (QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)new QuicServerCodecBuilder().sslContext(context)).initialMaxStreamsBidirectional(1L)).maxIdleTimeout(5L, TimeUnit.SECONDS)).initialMaxData(0x800000L)).initialMaxStreamDataBidirectionalRemote(0x800000L);
        boolean bl = false;
        secureRandom.nextBytes(p0);
        byte[] byArray3 = byArray;
        byArray = new byte[32];
        secureRandom = new SecureRandom();
        p0 = byArray;
        quicServerCodecBuilder = quicServerCodecBuilder.tokenHandler((QuicTokenHandler)new Blake3TokenHandler(byArray3));
        boolean bl2 = false;
        secureRandom.nextBytes(p0);
        byte[] byArray4 = byArray;
        ChannelHandler codec2 = quicServerCodecBuilder.connectionIdAddressGenerator((QuicConnectionIdGenerator)new Blake3ConnectionIdGenerator(byArray4)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(parentChannelAddresses, connections){
            final /* synthetic */ WeakHashMap<Channel, SocketAddress> $parentChannelAddresses;
            final /* synthetic */ List<class_2535> $connections;
            {
                this.$parentChannelAddresses = $parentChannelAddresses;
                this.$connections = $connections;
            }

            public void userEventTriggered(ChannelHandlerContext context, Object event) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof QuicPathEvent.New || event instanceof QuicPathEvent.PeerMigrated) {
                    InetSocketAddress newAddress = ((QuicPathEvent)event).remote();
                    ((Map)this.$parentChannelAddresses).put(context.channel(), newAddress);
                    for (class_2535 connection : this.$connections) {
                        SocketAddress oldAddress = connection.method_10755();
                        Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type industries._5505.quic_protocol_support.mixin.ClientConnectionAccessor");
                        ClientConnectionAccessor accessor = (ClientConnectionAccessor)connection;
                        if (!(accessor.getChannel() instanceof QuicStreamChannel) || !Intrinsics.areEqual((Object)accessor.getChannel().parent(), (Object)context.channel()) || newAddress.equals(oldAddress)) continue;
                        accessor.setAddress(newAddress);
                        QuicListener.access$getLogger$p().info("{} was migrated to {}", (Object)oldAddress, (Object)newAddress);
                    }
                }
                context.fireUserEventTriggered(event);
            }

            public void channelInactive(ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ((Map)this.$parentChannelAddresses).remove(context.channel());
                context.fireChannelInactive();
            }

            public boolean isSharable() {
                return true;
            }
        }).streamHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(server, connections, parentChannelAddresses){
            final /* synthetic */ class_3176 $server;
            final /* synthetic */ List<class_2535> $connections;
            final /* synthetic */ WeakHashMap<Channel, SocketAddress> $parentChannelAddresses;
            {
                this.$server = $server;
                this.$connections = $connections;
                this.$parentChannelAddresses = $parentChannelAddresses;
            }

            protected void initChannel(QuicStreamChannel channel) {
                block0: {
                    SocketAddress socketAddress;
                    Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                    ChannelPipeline channelPipeline = channel.pipeline();
                    class_2535.method_48311((ChannelPipeline)channelPipeline, (class_2598)class_2598.field_11941);
                    int rateLimit = this.$server.method_30612();
                    class_2535 clientConnection = rateLimit > 0 ? (class_2535)new class_5472(rateLimit) : new class_2535(class_2598.field_11941);
                    ((ClientConnectionAccessor)clientConnection).setEncrypted(true);
                    ((Collection)this.$connections).add(clientConnection);
                    channelPipeline.addLast("packet_handler", (ChannelHandler)clientConnection);
                    clientConnection.method_10763((class_2547)new class_3246((MinecraftServer)this.$server, clientConnection));
                    SocketAddress socketAddress2 = this.$parentChannelAddresses.get(channel.parent());
                    if (socketAddress2 == null) break block0;
                    SocketAddress it = socketAddress = socketAddress2;
                    boolean bl = false;
                    ((ClientConnectionAccessor)clientConnection).setAddress(it);
                }
            }
        }).build();
        ((Collection)channels).add(((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)(useEpoll ? (MultithreadEventLoopGroup)class_2535.field_11657.method_15332() : (MultithreadEventLoopGroup)class_2535.field_11650.method_15332()))).channel(useEpoll ? EpollDatagramChannel.class : NioDatagramChannel.class)).handler(codec2)).bind((SocketAddress)socketAddress).sync());
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }
}

