/*
 * Decompiled with CFR 0.152.
 */
package industries._5505.quic_protocol_support.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.digest.Blake3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0014\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lindustries/_5505/quic_protocol_support/quic/Blake3TokenHandler;", "Lio/netty/incubator/codec/quic/QuicTokenHandler;", "", "key", "<init>", "([B)V", "Lio/netty/buffer/ByteBuf;", "out", "dcid", "Ljava/net/InetSocketAddress;", "address", "", "writeToken", "(Lio/netty/buffer/ByteBuf;Lio/netty/buffer/ByteBuf;Ljava/net/InetSocketAddress;)Z", "token", "", "validateToken", "(Lio/netty/buffer/ByteBuf;Ljava/net/InetSocketAddress;)I", "", "windowId", "hash", "(Ljava/net/InetSocketAddress;Lio/netty/buffer/ByteBuf;J)[B", "maxTokenLength", "()I", "Lorg/apache/commons/codec/digest/Blake3;", "kotlin.jvm.PlatformType", "Lorg/apache/commons/codec/digest/Blake3;", "QuicProtocolSupport"})
public final class Blake3TokenHandler
implements QuicTokenHandler {
    private final Blake3 hash;

    public Blake3TokenHandler(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.hash = Blake3.initKeyedHash((byte[])key);
    }

    public boolean writeToken(@NotNull ByteBuf out, @NotNull ByteBuf dcid, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)dcid, (String)"dcid");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        out.writeBytes(this.hash(address, dcid, System.currentTimeMillis() / (long)300000));
        out.writeBytes(dcid, dcid.readerIndex(), dcid.readableBytes());
        return true;
    }

    public int validateToken(@NotNull ByteBuf token, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (token.readableBytes() < 32) {
            return -1;
        }
        byte[] hash = new byte[32];
        token.getBytes(token.readerIndex(), hash);
        ByteBuf dcid = token.slice(token.readerIndex() + 32, token.readableBytes() - 32);
        long windowId = System.currentTimeMillis() / (long)300000;
        Intrinsics.checkNotNull((Object)dcid);
        byte[] expectedHashNow = this.hash(address, dcid, windowId);
        byte[] expectedHashPrevious = this.hash(address, dcid, windowId - 1L);
        boolean equalNow = MessageDigest.isEqual(expectedHashNow, hash);
        boolean equalPrevious = MessageDigest.isEqual(expectedHashPrevious, hash);
        return equalNow | equalPrevious ? 32 : -1;
    }

    private final byte[] hash(InetSocketAddress address, ByteBuf dcid, long windowId) {
        ByteBuf byteBuf;
        int n = dcid.readableBytes();
        if (!(1 <= n ? n < 21 : false)) {
            boolean bl = false;
            String string = "connection ID may not be longer than 20 bytes";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuf $this$hash_u24lambda_u241 = byteBuf = Unpooled.buffer();
        boolean bl = false;
        $this$hash_u24lambda_u241.writeInt(address.getPort());
        $this$hash_u24lambda_u241.writeLong(windowId);
        $this$hash_u24lambda_u241.writeBytes(address.getAddress().getAddress());
        $this$hash_u24lambda_u241.writeBytes(dcid, dcid.readerIndex(), dcid.readableBytes());
        ByteBuf cleartext = byteBuf;
        this.hash.reset();
        this.hash.update(cleartext.array(), cleartext.arrayOffset() + cleartext.readerIndex(), cleartext.readableBytes());
        cleartext.release();
        byte[] byArray = this.hash.doFinalize(32);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinalize(...)");
        return byArray;
    }

    public int maxTokenLength() {
        return 52;
    }
}

