/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.google.common.collect.ImmutableMap;
import com.pekar.pouchandpaper.blocks.ModBlock;
import com.pekar.pouchandpaper.blocks.entity.PouchOfSeedsBlockEntity;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PouchOfSeeds
extends ModBlock {
    private static final int MAX_SEEDS_INSIDE = 60;
    private static final VoxelShape SHAPE_X = Shapes.create((double)0.234375, (double)0.0, (double)0.25, (double)0.671875, (double)0.4375, (double)0.5625);
    private static final VoxelShape SHAPE_X1 = Shapes.create((double)0.234375, (double)0.0, (double)0.4375, (double)0.671875, (double)0.4375, (double)0.75);
    private static final VoxelShape SHAPE_X2 = Shapes.create((double)0.28125, (double)0.0, (double)0.375, (double)0.765625, (double)0.4375, (double)0.796875);
    private static final VoxelShape SHAPE_X3 = Shapes.create((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.4375, (double)0.6875);
    private static final VoxelShape SHAPE_Z = Shapes.create((double)0.40625, (double)0.0, (double)0.328125, (double)0.71875, (double)0.4375, (double)0.765625);
    private static final VoxelShape SHAPE_Z1 = Shapes.create((double)0.28125, (double)0.0, (double)0.265625, (double)0.59375, (double)0.4375, (double)0.703125);
    private static final VoxelShape SHAPE_Z2 = Shapes.create((double)0.25, (double)0.0, (double)0.296875, (double)0.65625, (double)0.4375, (double)0.765625);
    private static final VoxelShape SHAPE_Z3 = Shapes.create((double)0.3125, (double)0.0, (double)0.25, (double)0.734375, (double)0.4375, (double)0.71875);
    public static final BooleanProperty FACING_ALONG_X = BooleanProperty.create((String)"facing_along_x");
    public static final IntegerProperty PLACING_OPTION = IntegerProperty.create((String)"placing_option", (int)0, (int)3);

    public PouchOfSeeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0)));
    }

    protected abstract DeferredBlock<Block> getPouchBlock();

    protected abstract Item getSeedsItem();

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(this.getPouchBlock().asItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof PouchOfSeedsBlockEntity)) {
                return ItemInteractionResult.CONSUME;
            }
            PouchOfSeedsBlockEntity pouchOfSeedsBlockEntity = (PouchOfSeedsBlockEntity)blockEntity;
            int seedsInside = pouchOfSeedsBlockEntity.getSeedsInside();
            if (seedsInside + 4 > 60) {
                return ItemInteractionResult.CONSUME;
            }
            pouchOfSeedsBlockEntity.setSeedsInside(seedsInside + 4);
            if (!level.isClientSide()) {
                player.getItemInHand(hand).shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.is(this.getSeedsItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof PouchOfSeedsBlockEntity)) {
                return ItemInteractionResult.CONSUME;
            }
            PouchOfSeedsBlockEntity pouchOfSeedsBlockEntity = (PouchOfSeedsBlockEntity)blockEntity;
            int seedsInside = pouchOfSeedsBlockEntity.getSeedsInside();
            if (seedsInside >= 60) {
                return ItemInteractionResult.CONSUME;
            }
            pouchOfSeedsBlockEntity.setSeedsInside(seedsInside + 1);
            if (!level.isClientSide()) {
                player.getItemInHand(hand).shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        int SeedsToDropNormally = 4;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PouchOfSeedsBlockEntity)) {
            return InteractionResult.FAIL;
        }
        PouchOfSeedsBlockEntity pouchOfSeedsBlockEntity = (PouchOfSeedsBlockEntity)blockEntity;
        int seedsInside = pouchOfSeedsBlockEntity.getSeedsInside();
        if (seedsInside < 1) {
            return InteractionResult.CONSUME;
        }
        int seedsToDrop = Math.min(seedsInside, 4);
        if (!level.isClientSide()) {
            PouchOfSeeds.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsToDrop));
        }
        pouchOfSeedsBlockEntity.setSeedsInside(seedsInside - seedsToDrop);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_ALONG_X, PLACING_OPTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        long seed = PouchOfSeeds.mixCoords(pos.getX(), pos.getY(), pos.getZ());
        Random rand = new Random(seed);
        int placingOption = rand.nextInt(4);
        Direction direction = context.getHorizontalDirection();
        return switch (direction) {
            case Direction.EAST, Direction.WEST -> (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
            default -> (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
        };
    }

    private static long mixCoords(int x, int y, int z) {
        long a = (long)x * 341873128712L;
        long b = (long)y * 132897987541L;
        long c = (long)z * 42317861L;
        return a ^ b ^ c;
    }

    protected ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        BlockState defaultBlockState = this.defaultBlockState();
        return ImmutableMap.of((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_X, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_X1, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_X2, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_X3, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_Z, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_Z1, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_Z2, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_Z3);
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShapeByBlockState(blockState);
    }

    private VoxelShape getShapeByBlockState(BlockState blockState) {
        boolean facingAlongX = (Boolean)blockState.getValue((Property)FACING_ALONG_X);
        int placingOption = (Integer)blockState.getValue((Property)PLACING_OPTION);
        if (facingAlongX) {
            return switch (placingOption) {
                case 0 -> SHAPE_X;
                case 1 -> SHAPE_X1;
                case 2 -> SHAPE_X2;
                case 3 -> SHAPE_X3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        return switch (placingOption) {
            case 0 -> SHAPE_Z;
            case 1 -> SHAPE_Z1;
            case 2 -> SHAPE_Z2;
            case 3 -> SHAPE_Z3;
            default -> throw new IllegalStateException("Unexpected value: " + placingOption);
        };
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        PouchOfSeedsBlockEntity pouchOfSeedsBlockEntity;
        int seedsInside;
        if (!level.isClientSide() && blockEntity instanceof PouchOfSeedsBlockEntity && (seedsInside = (pouchOfSeedsBlockEntity = (PouchOfSeedsBlockEntity)blockEntity).getSeedsInside()) > 0) {
            PouchOfSeeds.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsInside));
        }
        PouchOfSeeds.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)this.getPouchBlock().toStack());
    }
}

