/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.utils;

import com.pekar.pouchandpaper.tooltip.ITooltip;
import com.pekar.pouchandpaper.utils.TextStyle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Text {
    Text() {
    }

    public boolean showExtendedDescription(ITooltip tooltip) {
        if (!Screen.hasShiftDown()) {
            tooltip.addLineById("description.press_shift").apply();
            return false;
        }
        return true;
    }

    public MutableComponent getFormattedTextComponent(MutableComponent initialComponent, boolean isHeader, boolean isSubHeader, boolean isNotice, boolean isImportantNotice, boolean isDarkGray) {
        TextStyle textStyle = isHeader ? TextStyle.Header : (isSubHeader ? TextStyle.Subheader : (isNotice ? TextStyle.Notice : (isImportantNotice ? TextStyle.ImportantNotice : (isDarkGray ? TextStyle.DarkGray : TextStyle.Regular))));
        return this.getDescription(initialComponent, textStyle);
    }

    public MutableComponent getDescription(MutableComponent initialComponent, TextStyle textStyle) {
        return switch (textStyle) {
            case TextStyle.Header -> initialComponent.withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE);
            case TextStyle.Subheader -> initialComponent.withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GRAY);
            case TextStyle.Notice -> initialComponent.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
            case TextStyle.ImportantNotice -> initialComponent.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.WHITE);
            case TextStyle.DarkGray -> initialComponent.withStyle(ChatFormatting.DARK_GRAY);
            default -> initialComponent.withStyle(ChatFormatting.RESET).withStyle(ChatFormatting.GRAY);
        };
    }

    public boolean showExtendedDescription(List<Component> tooltipComponents) {
        if (!Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"description.press_shift"));
            return false;
        }
        return true;
    }
}

