/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.tooltip;

import com.pekar.pouchandpaper.tooltip.ITooltipLine;
import com.pekar.pouchandpaper.tooltip.TextStyle;
import com.pekar.pouchandpaper.tooltip.Tooltip;
import javax.annotation.CheckReturnValue;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TooltipLine
implements ITooltipLine {
    private final Tooltip tooltip;
    private final MutableComponent component;
    private final boolean ignoreEmptyLines;

    TooltipLine(Tooltip tooltip, String descriptionRoot, boolean ignoreEmptyLines) {
        this.tooltip = tooltip;
        this.component = Component.translatable((String)descriptionRoot).withStyle(ChatFormatting.GRAY);
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    TooltipLine(Tooltip tooltip) {
        this.tooltip = tooltip;
        this.component = Component.empty();
        this.ignoreEmptyLines = false;
    }

    @Override
    @CheckReturnValue
    public ITooltipLine styledAs(TextStyle style, boolean applyStyle) {
        if (applyStyle) {
            switch (style) {
                case Header: {
                    this.component.withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE);
                    break;
                }
                case Subheader: {
                    this.component.withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GRAY);
                    break;
                }
                case Notice: {
                    this.component.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
                    break;
                }
                case ImportantNotice: {
                    this.component.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.WHITE);
                    break;
                }
                case DarkGray: {
                    this.component.withStyle(ChatFormatting.DARK_GRAY);
                    break;
                }
                default: {
                    this.component.withStyle(ChatFormatting.RESET).withStyle(ChatFormatting.GRAY);
                }
            }
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine asHeader() {
        return this.styledAs(TextStyle.Header);
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine asSubHeader() {
        return this.styledAs(TextStyle.Subheader);
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine asNotice() {
        return this.styledAs(TextStyle.Notice);
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine asImportantNotice() {
        return this.styledAs(TextStyle.ImportantNotice);
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine asDarkGrey() {
        return this.styledAs(TextStyle.DarkGray);
    }

    @Override
    @CheckReturnValue
    public final ITooltipLine withFormatting(ChatFormatting formatting, boolean applyFormatting) {
        if (applyFormatting) {
            this.component.withStyle(formatting);
        }
        return this;
    }

    @Override
    public final void apply() {
        if (this.isEmpty() && this.ignoreEmptyLines) {
            return;
        }
        this.tooltip.apply(this);
    }

    final Component getComponent() {
        return this.component;
    }

    private boolean isEmpty() {
        return this.component.getString().isEmpty();
    }

    private ITooltipLine styledAs(TextStyle style) {
        return this.styledAs(style, true);
    }
}

