/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.google.common.collect.ImmutableMap;
import com.pekar.pouchandpaper.blocks.FarmContainer;
import com.pekar.pouchandpaper.blocks.entity.FarmContainerBlockEntity;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FarmSack
extends FarmContainer {
    private static final VoxelShape SHAPE_FULL = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)1.0, (double)0.9375);
    private static final VoxelShape SHAPE_FULL1 = Shapes.create((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)1.0, (double)0.90625);
    private static final VoxelShape SHAPE_FULL2 = Shapes.create((double)0.078125, (double)0.0, (double)0.09375, (double)0.828125, (double)1.0, (double)0.953125);
    private static final VoxelShape SHAPE_FULL3 = Shapes.create((double)0.109375, (double)0.0, (double)0.109375, (double)0.953125, (double)1.0, (double)0.953125);
    private static final VoxelShape SHAPE_SEMI = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)0.75, (double)0.9375);
    private static final VoxelShape SHAPE_SEMI1 = Shapes.create((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)0.75, (double)0.90625);
    private static final VoxelShape SHAPE_SEMI2 = Shapes.create((double)0.078125, (double)0.0, (double)0.09375, (double)0.828125, (double)0.75, (double)0.953125);
    private static final VoxelShape SHAPE_SEMI3 = Shapes.create((double)0.109375, (double)0.0, (double)0.109375, (double)0.953125, (double)0.75, (double)0.953125);
    private static final VoxelShape SHAPE_EMPTY = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)0.5, (double)0.9375);
    private static final VoxelShape SHAPE_EMPTY1 = Shapes.create((double)0.0625, (double)0.0, (double)0.234375, (double)0.953125, (double)0.5, (double)0.890625);
    private static final VoxelShape SHAPE_EMPTY2 = Shapes.create((double)0.046875, (double)0.0, (double)0.0625, (double)0.8125, (double)0.5, (double)0.9375);
    private static final VoxelShape SHAPE_EMPTY3 = Shapes.create((double)0.09375, (double)0.0, (double)0.125, (double)0.90625, (double)0.5, (double)0.9375);
    private static final VoxelShape COLLISION_FULL = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.99, (double)0.8125);
    private static final VoxelShape COLLISION_FULL1 = Shapes.create((double)0.1875, (double)0.0, (double)0.375, (double)0.8125, (double)0.99, (double)0.78125);
    private static final VoxelShape COLLISION_FULL2 = Shapes.create((double)0.203125, (double)0.0, (double)0.21875, (double)0.703125, (double)0.99, (double)0.828125);
    private static final VoxelShape COLLISION_FULL3 = Shapes.create((double)0.234375, (double)0.0, (double)0.234375, (double)0.828125, (double)0.99, (double)0.828125);
    private static final VoxelShape COLLISION_SEMI = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.74, (double)0.8125);
    private static final VoxelShape COLLISION_SEMI1 = Shapes.create((double)0.1875, (double)0.0, (double)0.375, (double)0.8125, (double)0.74, (double)0.78125);
    private static final VoxelShape COLLISION_SEMI2 = Shapes.create((double)0.203125, (double)0.0, (double)0.21875, (double)0.703125, (double)0.74, (double)0.828125);
    private static final VoxelShape COLLISION_SEMI3 = Shapes.create((double)0.234375, (double)0.0, (double)0.234375, (double)0.828125, (double)0.74, (double)0.828125);
    private static final VoxelShape COLLISION_EMPTY = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.5, (double)0.8125);
    private static final VoxelShape COLLISION_EMPTY1 = Shapes.create((double)0.1875, (double)0.0, (double)0.359375, (double)0.828125, (double)0.5, (double)0.765625);
    private static final VoxelShape COLLISION_EMPTY2 = Shapes.create((double)0.171875, (double)0.0, (double)0.1875, (double)0.6875, (double)0.5, (double)0.8125);
    private static final VoxelShape COLLISION_EMPTY3 = Shapes.create((double)0.21875, (double)0.0, (double)0.25, (double)0.78125, (double)0.5, (double)0.8125);
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.create((String)"fill_level", (int)0, (int)2);

    public FarmSack(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILL_LEVEL, PLACING_OPTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        long seed = FarmSack.mixCoords(pos.getX(), pos.getY(), pos.getZ());
        Random rand = new Random(seed);
        int placingOption = rand.nextInt(4);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
    }

    protected ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        BlockState defaultBlockState = this.defaultBlockState();
        return ImmutableMap.builder().put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_EMPTY).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_EMPTY1).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_EMPTY2).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_EMPTY3).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_SEMI).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_SEMI1).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_SEMI2).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_SEMI3).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(2))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_FULL).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(2))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_FULL1).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(2))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_FULL2).put((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(2))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_FULL3).build();
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShapeByBlockState(blockState);
    }

    private VoxelShape getShapeByBlockState(BlockState blockState) {
        int fillLevel = (Integer)blockState.getValue((Property)FILL_LEVEL);
        int placingOption = (Integer)blockState.getValue((Property)PLACING_OPTION);
        if (fillLevel == 0) {
            return switch (placingOption) {
                case 0 -> SHAPE_EMPTY;
                case 1 -> SHAPE_EMPTY1;
                case 2 -> SHAPE_EMPTY2;
                case 3 -> SHAPE_EMPTY3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        if (fillLevel == 1) {
            return switch (placingOption) {
                case 0 -> SHAPE_SEMI;
                case 1 -> SHAPE_SEMI1;
                case 2 -> SHAPE_SEMI2;
                case 3 -> SHAPE_SEMI3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        return switch (placingOption) {
            case 0 -> SHAPE_FULL;
            case 1 -> SHAPE_FULL1;
            case 2 -> SHAPE_FULL2;
            case 3 -> SHAPE_FULL3;
            default -> throw new IllegalStateException("Unexpected value: " + placingOption);
        };
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(this.getPouchBlock().asItem()) || stack.is(this.getSeedsItem())) {
            this.updateFillLevel(state, level, pos);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.updateFillLevel(state, level, pos);
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int fillLevel = (Integer)state.getValue((Property)FILL_LEVEL);
        int placingOption = (Integer)state.getValue((Property)PLACING_OPTION);
        return switch (fillLevel) {
            case 0 -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_EMPTY;
                    }
                    case 1: {
                        yield COLLISION_EMPTY1;
                    }
                    case 2: {
                        yield COLLISION_EMPTY2;
                    }
                    case 3: {
                        yield COLLISION_EMPTY3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
            case 1 -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_SEMI;
                    }
                    case 1: {
                        yield COLLISION_SEMI1;
                    }
                    case 2: {
                        yield COLLISION_SEMI2;
                    }
                    case 3: {
                        yield COLLISION_SEMI3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
            default -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_FULL;
                    }
                    case 1: {
                        yield COLLISION_FULL1;
                    }
                    case 2: {
                        yield COLLISION_FULL2;
                    }
                    case 3: {
                        yield COLLISION_FULL3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
        };
    }

    private void updateFillLevel(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FarmContainerBlockEntity) {
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seeds = containerBlockEntity.getSeedsInside();
            int fillLevel = seeds > 42 ? 2 : (seeds > 21 ? 1 : 0);
            if ((Integer)state.getValue((Property)FILL_LEVEL) != fillLevel) {
                BlockState newState = (BlockState)state.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(fillLevel));
                level.setBlock(pos, newState, 3);
            }
        }
    }
}

