/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.google.common.collect.ImmutableMap;
import com.pekar.pouchandpaper.blocks.FarmContainer;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PouchOfSeeds
extends FarmContainer {
    private static final VoxelShape SHAPE_X = Shapes.create((double)0.234375, (double)0.0, (double)0.25, (double)0.671875, (double)0.4375, (double)0.5625);
    private static final VoxelShape SHAPE_X1 = Shapes.create((double)0.234375, (double)0.0, (double)0.4375, (double)0.671875, (double)0.4375, (double)0.75);
    private static final VoxelShape SHAPE_X2 = Shapes.create((double)0.28125, (double)0.0, (double)0.375, (double)0.765625, (double)0.4375, (double)0.796875);
    private static final VoxelShape SHAPE_X3 = Shapes.create((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.4375, (double)0.6875);
    private static final VoxelShape SHAPE_Z = Shapes.create((double)0.40625, (double)0.0, (double)0.328125, (double)0.71875, (double)0.4375, (double)0.765625);
    private static final VoxelShape SHAPE_Z1 = Shapes.create((double)0.28125, (double)0.0, (double)0.265625, (double)0.59375, (double)0.4375, (double)0.703125);
    private static final VoxelShape SHAPE_Z2 = Shapes.create((double)0.25, (double)0.0, (double)0.296875, (double)0.65625, (double)0.4375, (double)0.765625);
    private static final VoxelShape SHAPE_Z3 = Shapes.create((double)0.3125, (double)0.0, (double)0.25, (double)0.734375, (double)0.4375, (double)0.71875);
    public static final BooleanProperty FACING_ALONG_X = BooleanProperty.create((String)"facing_along_x");

    public PouchOfSeeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_ALONG_X, PLACING_OPTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        long seed = PouchOfSeeds.mixCoords(pos.getX(), pos.getY(), pos.getZ());
        Random rand = new Random(seed);
        int placingOption = rand.nextInt(4);
        Direction direction = context.getHorizontalDirection();
        return switch (direction) {
            case Direction.EAST, Direction.WEST -> (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
            default -> (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
        };
    }

    protected ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        BlockState defaultBlockState = this.defaultBlockState();
        return ImmutableMap.of((Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_X, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_X1, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_X2, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_X3, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0))), (Object)SHAPE_Z, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(1))), (Object)SHAPE_Z1, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(2))), (Object)SHAPE_Z2, (Object)((BlockState)((BlockState)defaultBlockState.setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(3))), (Object)SHAPE_Z3);
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShapeByBlockState(blockState);
    }

    private VoxelShape getShapeByBlockState(BlockState blockState) {
        boolean facingAlongX = (Boolean)blockState.getValue((Property)FACING_ALONG_X);
        int placingOption = (Integer)blockState.getValue((Property)PLACING_OPTION);
        if (facingAlongX) {
            return switch (placingOption) {
                case 0 -> SHAPE_X;
                case 1 -> SHAPE_X1;
                case 2 -> SHAPE_X2;
                case 3 -> SHAPE_X3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        return switch (placingOption) {
            case 0 -> SHAPE_Z;
            case 1 -> SHAPE_Z1;
            case 2 -> SHAPE_Z2;
            case 3 -> SHAPE_Z3;
            default -> throw new IllegalStateException("Unexpected value: " + placingOption);
        };
    }
}

