/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.tooltip;

import com.pekar.pouchandpaper.tooltip.ITooltip;
import com.pekar.pouchandpaper.tooltip.ITooltipLine;
import com.pekar.pouchandpaper.tooltip.TooltipLine;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import net.minecraft.network.chat.Component;

public class Tooltip
implements ITooltip {
    private final Consumer<Component> tooltipComponent;
    private boolean ignoreEmptyLines;

    private Tooltip(Consumer<Component> tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
    }

    public static ITooltip create(Consumer<Component> tooltipComponent) {
        return new Tooltip(tooltipComponent);
    }

    @Override
    public ITooltip ignoreEmptyLines() {
        this.ignoreEmptyLines = true;
        return this;
    }

    @Override
    public ITooltip includeEmptyLines() {
        this.ignoreEmptyLines = false;
        return this;
    }

    @Override
    @CheckReturnValue
    public void addEmptyLine() {
        this.tooltipComponent.accept(new TooltipLine(this).getComponent());
    }

    @Override
    public ITooltipLine addLineById(String descriptionId) {
        return new TooltipLine(this, descriptionId, this.ignoreEmptyLines);
    }

    @Override
    @CheckReturnValue
    public ITooltipLine addLine(String descriptionRoot) {
        return this.addLineById(descriptionRoot + ".desc");
    }

    @Override
    @CheckReturnValue
    public ITooltipLine addLine(String descriptionRoot, int descNumber) {
        return this.addLineById(descriptionRoot + ".desc" + descNumber);
    }

    void apply(TooltipLine tooltipLine) {
        this.tooltipComponent.accept(tooltipLine.getComponent());
    }
}

