/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.mojang.serialization.MapCodec;
import com.pekar.pouchandpaper.blocks.BlockRegistry;
import com.pekar.pouchandpaper.blocks.ISupportHoverText;
import com.pekar.pouchandpaper.items.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PaperBlock
extends FallingBlock
implements ISupportHoverText {
    private static final MapCodec<PaperBlock> CODEC = PaperBlock.simpleCodec(PaperBlock::new);

    public PaperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        if (fallDistance > 3.0f) {
            PaperBlock.dropBlock(level, pos);
        }
    }

    private static void dropBlock(Level level, BlockPos pos) {
        int paperStacks = level.random.nextIntBetweenInclusive(0, 4);
        int papers = 12 - paperStacks * 3;
        PaperBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.PAPER_STACK.get(), paperStacks));
        PaperBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.PAPER, papers));
        level.removeBlock(pos, false);
    }

    public void onLand(Level level, BlockPos pos, BlockState blockState, BlockState blockState1, FallingBlockEntity fallingBlockEntity) {
        PaperBlock.dropBlock(level, pos);
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        PaperBlock.dropBlock((Level)level, pos);
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        int val;
        if (serverLevel.getBlockState(pos.above()).is(Blocks.FIRE) && (val = randomSource.nextIntBetweenInclusive(0, 4)) == 0) {
            serverLevel.setBlock(pos, ((Block)BlockRegistry.BURNT_PAPER_BLOCK.get()).defaultBlockState(), 3);
        }
        super.tick(blockState, serverLevel, pos, randomSource);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 200;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 10;
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }
}

