/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.pekar.pouchandpaper.blocks.ModBlock;
import com.pekar.pouchandpaper.blocks.entity.FarmContainerBlockEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public abstract class FarmContainer
extends ModBlock {
    public static final IntegerProperty PLACING_OPTION = IntegerProperty.create((String)"placing_option", (int)0, (int)3);
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.create((String)"fill_level", (int)0, (int)2);
    private static final int POUCHES_TO_ADD_PER_USE = 16;
    private static final int SEEDS_TO_ADD_PER_USE = 64;
    private static final int SEEDS_TO_EXTRACT_PER_USE = 16;
    private static final int SEEDS_PER_POUCH_TO_CRAFT = 4;
    private static final int MAX_SEEDS_INSIDE = 252;

    public FarmContainer(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected abstract DeferredBlock<Block> getPouchBlock();

    protected abstract Item getSeedsItem();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILL_LEVEL, PLACING_OPTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        long seed = FarmContainer.mixCoords(pos.getX(), pos.getY(), pos.getZ());
        Random rand = new Random(seed);
        int placingOption = rand.nextInt(4);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(placingOption));
    }

    private static long mixCoords(int x, int y, int z) {
        long a = (long)x * 341873128712L;
        long b = (long)y * 132897987541L;
        long c = (long)z * 42317861L;
        return a ^ b ^ c;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult.Success consume = this.useItemOnInternal(stack, state, level, pos, player, hand);
        this.updateFillLevel(state, level, pos);
        if (consume != null) {
            return consume;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable InteractionResult.Success useItemOnInternal(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (stack.is(this.getPouchBlock().asItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FarmContainerBlockEntity)) {
                return InteractionResult.CONSUME;
            }
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (seedsInside + 4 > 252) {
                return InteractionResult.CONSUME;
            }
            int pouchesToAdd = 1;
            if (!player.isShiftKeyDown()) {
                int pouchesInHand = player.isCreative() && stack.getCount() > 0 ? stack.getMaxStackSize() : stack.getCount();
                int freeSpace = (252 - seedsInside) / 4;
                pouchesToAdd = Math.min(Math.min(pouchesInHand, 16), freeSpace);
            }
            containerBlockEntity.setSeedsInside(seedsInside + pouchesToAdd * 4);
            if (!level.isClientSide() && !player.isCreative()) {
                player.getItemInHand(hand).shrink(pouchesToAdd);
            }
            return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        if (stack.is(this.getSeedsItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FarmContainerBlockEntity)) {
                return InteractionResult.CONSUME;
            }
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (seedsInside >= 252) {
                return InteractionResult.CONSUME;
            }
            int seedsToAdd = 1;
            if (!player.isShiftKeyDown()) {
                int seedsInHand = player.isCreative() && stack.getCount() > 0 ? stack.getMaxStackSize() : stack.getCount();
                int freeSpace = 252 - seedsInside;
                seedsToAdd = Math.min(Math.min(seedsInHand, 64), freeSpace);
            }
            containerBlockEntity.setSeedsInside(seedsInside + seedsToAdd);
            if (!level.isClientSide() && !player.isCreative()) {
                player.getItemInHand(hand).shrink(seedsToAdd);
            }
            return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = this.useWithoutItemInternal(level, pos, player);
        this.updateFillLevel(state, level, pos);
        return result;
    }

    private InteractionResult useWithoutItemInternal(Level level, BlockPos pos, Player player) {
        int seedsToWithdraw;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FarmContainerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
        int seedsInside = containerBlockEntity.getSeedsInside();
        if (seedsInside < 1) {
            return InteractionResult.CONSUME;
        }
        int n = seedsToWithdraw = player.isShiftKeyDown() ? 1 : Math.min(seedsInside, 16);
        if (!level.isClientSide()) {
            FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsToWithdraw));
        }
        containerBlockEntity.setSeedsInside(seedsInside - seedsToWithdraw);
        return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!level.isClientSide() && blockEntity instanceof FarmContainerBlockEntity) {
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (player.isShiftKeyDown()) {
                int pouches = seedsInside / 4;
                int seeds = seedsInside % 4;
                FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)this.getPouchBlock().toStack(pouches + 1));
                if (seeds > 0) {
                    FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seeds));
                }
            } else {
                FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsInside + 4));
            }
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.isSolidRender() || blockBelow.is(Blocks.FARMLAND) || blockBelow.is(Blocks.DIRT_PATH);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!level.isClientSide() && blockEntity instanceof FarmContainerBlockEntity) {
                FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
                int seedsInside = containerBlockEntity.getSeedsInside();
                if (seedsInside > 0) {
                    FarmContainer.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsInside));
                }
                FarmContainer.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getPouchBlock().toStack());
                level.removeBlock(pos, false);
            }
        }
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
    }

    private void updateFillLevel(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FarmContainerBlockEntity) {
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seeds = containerBlockEntity.getSeedsInside();
            int fillLevel = seeds > 248 ? 2 : (seeds >= 4 ? 1 : 0);
            if ((Integer)state.getValue((Property)FILL_LEVEL) != fillLevel) {
                BlockState newState = (BlockState)state.setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(fillLevel));
                level.setBlock(pos, newState, 3);
            }
        }
    }
}

