/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.pekar.pouchandpaper.blocks.FarmContainer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class FarmSack
extends FarmContainer {
    private static final VoxelShape SHAPE_FULL = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)1.0, (double)0.9375);
    private static final VoxelShape SHAPE_FULL1 = Shapes.create((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)1.0, (double)0.90625);
    private static final VoxelShape SHAPE_FULL2 = Shapes.create((double)0.078125, (double)0.0, (double)0.09375, (double)0.828125, (double)1.0, (double)0.953125);
    private static final VoxelShape SHAPE_FULL3 = Shapes.create((double)0.109375, (double)0.0, (double)0.109375, (double)0.953125, (double)1.0, (double)0.953125);
    private static final VoxelShape SHAPE_SEMI = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)0.75, (double)0.9375);
    private static final VoxelShape SHAPE_SEMI1 = Shapes.create((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)0.75, (double)0.90625);
    private static final VoxelShape SHAPE_SEMI2 = Shapes.create((double)0.078125, (double)0.0, (double)0.09375, (double)0.828125, (double)0.75, (double)0.953125);
    private static final VoxelShape SHAPE_SEMI3 = Shapes.create((double)0.109375, (double)0.0, (double)0.109375, (double)0.953125, (double)0.75, (double)0.953125);
    private static final VoxelShape SHAPE_EMPTY = Shapes.create((double)0.1875, (double)0.0, (double)0.0625, (double)0.84375, (double)0.5, (double)0.9375);
    private static final VoxelShape SHAPE_EMPTY1 = Shapes.create((double)0.0625, (double)0.0, (double)0.234375, (double)0.953125, (double)0.5, (double)0.890625);
    private static final VoxelShape SHAPE_EMPTY2 = Shapes.create((double)0.046875, (double)0.0, (double)0.0625, (double)0.8125, (double)0.5, (double)0.9375);
    private static final VoxelShape SHAPE_EMPTY3 = Shapes.create((double)0.09375, (double)0.0, (double)0.125, (double)0.90625, (double)0.5, (double)0.9375);
    private static final VoxelShape COLLISION_FULL = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.99, (double)0.8125);
    private static final VoxelShape COLLISION_FULL1 = Shapes.create((double)0.1875, (double)0.0, (double)0.375, (double)0.8125, (double)0.99, (double)0.78125);
    private static final VoxelShape COLLISION_FULL2 = Shapes.create((double)0.203125, (double)0.0, (double)0.21875, (double)0.703125, (double)0.99, (double)0.828125);
    private static final VoxelShape COLLISION_FULL3 = Shapes.create((double)0.234375, (double)0.0, (double)0.234375, (double)0.828125, (double)0.99, (double)0.828125);
    private static final VoxelShape COLLISION_SEMI = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.74, (double)0.8125);
    private static final VoxelShape COLLISION_SEMI1 = Shapes.create((double)0.1875, (double)0.0, (double)0.375, (double)0.8125, (double)0.74, (double)0.78125);
    private static final VoxelShape COLLISION_SEMI2 = Shapes.create((double)0.203125, (double)0.0, (double)0.21875, (double)0.703125, (double)0.74, (double)0.828125);
    private static final VoxelShape COLLISION_SEMI3 = Shapes.create((double)0.234375, (double)0.0, (double)0.234375, (double)0.828125, (double)0.74, (double)0.828125);
    private static final VoxelShape COLLISION_EMPTY = Shapes.create((double)0.3125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.5, (double)0.8125);
    private static final VoxelShape COLLISION_EMPTY1 = Shapes.create((double)0.1875, (double)0.0, (double)0.359375, (double)0.828125, (double)0.5, (double)0.765625);
    private static final VoxelShape COLLISION_EMPTY2 = Shapes.create((double)0.171875, (double)0.0, (double)0.1875, (double)0.6875, (double)0.5, (double)0.8125);
    private static final VoxelShape COLLISION_EMPTY3 = Shapes.create((double)0.21875, (double)0.0, (double)0.25, (double)0.78125, (double)0.5, (double)0.8125);

    public FarmSack(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        return this::getShapeByBlockState;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShapeByBlockState(blockState);
    }

    private VoxelShape getShapeByBlockState(BlockState blockState) {
        int fillLevel = (Integer)blockState.getValue((Property)FILL_LEVEL);
        int placingOption = (Integer)blockState.getValue((Property)PLACING_OPTION);
        if (fillLevel == 0) {
            return switch (placingOption) {
                case 0 -> SHAPE_EMPTY;
                case 1 -> SHAPE_EMPTY1;
                case 2 -> SHAPE_EMPTY2;
                case 3 -> SHAPE_EMPTY3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        if (fillLevel == 1) {
            return switch (placingOption) {
                case 0 -> SHAPE_SEMI;
                case 1 -> SHAPE_SEMI1;
                case 2 -> SHAPE_SEMI2;
                case 3 -> SHAPE_SEMI3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        return switch (placingOption) {
            case 0 -> SHAPE_FULL;
            case 1 -> SHAPE_FULL1;
            case 2 -> SHAPE_FULL2;
            case 3 -> SHAPE_FULL3;
            default -> throw new IllegalStateException("Unexpected value: " + placingOption);
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int fillLevel = (Integer)state.getValue((Property)FILL_LEVEL);
        int placingOption = (Integer)state.getValue((Property)PLACING_OPTION);
        return switch (fillLevel) {
            case 0 -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_EMPTY;
                    }
                    case 1: {
                        yield COLLISION_EMPTY1;
                    }
                    case 2: {
                        yield COLLISION_EMPTY2;
                    }
                    case 3: {
                        yield COLLISION_EMPTY3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
            case 1 -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_SEMI;
                    }
                    case 1: {
                        yield COLLISION_SEMI1;
                    }
                    case 2: {
                        yield COLLISION_SEMI2;
                    }
                    case 3: {
                        yield COLLISION_SEMI3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
            default -> {
                switch (placingOption) {
                    case 0: {
                        yield COLLISION_FULL;
                    }
                    case 1: {
                        yield COLLISION_FULL1;
                    }
                    case 2: {
                        yield COLLISION_FULL2;
                    }
                    case 3: {
                        yield COLLISION_FULL3;
                    }
                }
                throw new IllegalStateException("Unexpected placingOption: " + placingOption);
            }
        };
    }
}

