/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.pekar.pouchandpaper.blocks.FarmContainer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class PouchOfSeeds
extends FarmContainer {
    private static final VoxelShape SHAPE_EMPTY = Shapes.create((double)0.25, (double)0.0, (double)0.265625, (double)0.671875, (double)0.125, (double)0.53125);
    private static final VoxelShape SHAPE_EMPTY1 = Shapes.create((double)0.296875, (double)0.0, (double)0.375, (double)0.765625, (double)0.125, (double)0.765625);
    private static final VoxelShape SHAPE_EMPTY2 = Shapes.create((double)0.265625, (double)0.0, (double)0.296875, (double)0.65625, (double)0.125, (double)0.765625);
    private static final VoxelShape SHAPE_EMPTY3 = Shapes.create((double)0.34375, (double)0.0, (double)0.25, (double)0.734375, (double)0.125, (double)0.71875);
    private static final VoxelShape SHAPE_SEMI = Shapes.create((double)0.234375, (double)0.0, (double)0.25, (double)0.671875, (double)0.25, (double)0.5625);
    private static final VoxelShape SHAPE_SEMI1 = Shapes.create((double)0.28125, (double)0.0, (double)0.375, (double)0.765625, (double)0.25, (double)0.796875);
    private static final VoxelShape SHAPE_SEMI2 = Shapes.create((double)0.25, (double)0.0, (double)0.296875, (double)0.65625, (double)0.25, (double)0.765625);
    private static final VoxelShape SHAPE_SEMI3 = Shapes.create((double)0.3125, (double)0.0, (double)0.25, (double)0.734375, (double)0.25, (double)0.71875);
    private static final VoxelShape SHAPE_FULL = Shapes.create((double)0.234375, (double)0.0, (double)0.25, (double)0.671875, (double)0.4375, (double)0.5625);
    private static final VoxelShape SHAPE_FULL1 = Shapes.create((double)0.28125, (double)0.0, (double)0.375, (double)0.765625, (double)0.4375, (double)0.796875);
    private static final VoxelShape SHAPE_FULL2 = Shapes.create((double)0.25, (double)0.0, (double)0.296875, (double)0.65625, (double)0.4375, (double)0.765625);
    private static final VoxelShape SHAPE_FULL3 = Shapes.create((double)0.3125, (double)0.0, (double)0.25, (double)0.734375, (double)0.4375, (double)0.71875);

    public PouchOfSeeds(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        return this::getShapeByBlockState;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShapeByBlockState(blockState);
    }

    private VoxelShape getShapeByBlockState(BlockState blockState) {
        int fillLevel = (Integer)blockState.getValue((Property)FILL_LEVEL);
        int placingOption = (Integer)blockState.getValue((Property)PLACING_OPTION);
        if (fillLevel == 0) {
            return switch (placingOption) {
                case 0 -> SHAPE_EMPTY;
                case 1 -> SHAPE_EMPTY1;
                case 2 -> SHAPE_EMPTY2;
                case 3 -> SHAPE_EMPTY3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        if (fillLevel == 1) {
            return switch (placingOption) {
                case 0 -> SHAPE_SEMI;
                case 1 -> SHAPE_SEMI1;
                case 2 -> SHAPE_SEMI2;
                case 3 -> SHAPE_SEMI3;
                default -> throw new IllegalStateException("Unexpected value: " + placingOption);
            };
        }
        return switch (placingOption) {
            case 0 -> SHAPE_FULL;
            case 1 -> SHAPE_FULL1;
            case 2 -> SHAPE_FULL2;
            case 3 -> SHAPE_FULL3;
            default -> throw new IllegalStateException("Unexpected value: " + placingOption);
        };
    }
}

