/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class FarmContainerBlockEntity
extends BlockEntity {
    private int seedsInside;

    public FarmContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.seedsInside = input.getIntOr("seeds_inside", 0);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("seeds_inside", this.seedsInside);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveModTag(tag);
        return tag;
    }

    public void setSeedsInside(int pouchesInside) {
        this.seedsInside = pouchesInside;
        this.setChanged();
    }

    public int getSeedsInside() {
        return this.seedsInside;
    }

    private void saveModTag(CompoundTag tag) {
        tag.putInt("seeds_inside", this.seedsInside);
    }
}

