/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.pekar.pouchandpaper.blocks.ModBlock;
import com.pekar.pouchandpaper.blocks.entity.FarmContainerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public abstract class FarmContainer
extends ModBlock {
    public static final IntegerProperty PLACING_OPTION = IntegerProperty.create((String)"placing_option", (int)0, (int)3);
    private static final int MAX_SEEDS_INSIDE = 60;

    public FarmContainer(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLACING_OPTION, (Comparable)Integer.valueOf(0)));
    }

    protected static long mixCoords(int x, int y, int z) {
        long a = (long)x * 341873128712L;
        long b = (long)y * 132897987541L;
        long c = (long)z * 42317861L;
        return a ^ b ^ c;
    }

    protected abstract DeferredBlock<Block> getPouchBlock();

    protected abstract Item getSeedsItem();

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(this.getPouchBlock().asItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FarmContainerBlockEntity)) {
                return InteractionResult.CONSUME;
            }
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (seedsInside + 4 > 60) {
                return InteractionResult.CONSUME;
            }
            containerBlockEntity.setSeedsInside(seedsInside + 4);
            if (!level.isClientSide()) {
                player.getItemInHand(hand).shrink(1);
            }
            return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        if (stack.is(this.getSeedsItem())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FarmContainerBlockEntity)) {
                return InteractionResult.CONSUME;
            }
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (seedsInside >= 60) {
                return InteractionResult.CONSUME;
            }
            containerBlockEntity.setSeedsInside(seedsInside + 1);
            if (!level.isClientSide()) {
                player.getItemInHand(hand).shrink(1);
            }
            return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        int SeedsToDropNormally = 4;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FarmContainerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
        int seedsInside = containerBlockEntity.getSeedsInside();
        if (seedsInside < 1) {
            return InteractionResult.CONSUME;
        }
        int seedsToDrop = Math.min(seedsInside, 4);
        if (!level.isClientSide()) {
            FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsToDrop));
        }
        containerBlockEntity.setSeedsInside(seedsInside - seedsToDrop);
        return level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!level.isClientSide() && blockEntity instanceof FarmContainerBlockEntity) {
            FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
            int seedsInside = containerBlockEntity.getSeedsInside();
            if (seedsInside > 0) {
                FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsInside));
            }
            FarmContainer.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)player.getDirection().getOpposite(), (ItemStack)this.getPouchBlock().toStack());
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.isSolidRender() || blockBelow.is(Blocks.FARMLAND) || blockBelow.is(Blocks.DIRT_PATH);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!level.isClientSide() && blockEntity instanceof FarmContainerBlockEntity) {
                FarmContainerBlockEntity containerBlockEntity = (FarmContainerBlockEntity)blockEntity;
                int seedsInside = containerBlockEntity.getSeedsInside();
                if (seedsInside > 0) {
                    FarmContainer.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getSeedsItem(), seedsInside));
                }
                FarmContainer.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getPouchBlock().toStack());
                level.removeBlock(pos, false);
            }
        }
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
    }
}

