/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.pekar.pouchandpaper.Main;
import com.pekar.pouchandpaper.blocks.BurntPaperBlock;
import com.pekar.pouchandpaper.blocks.ModBlockItem;
import com.pekar.pouchandpaper.blocks.PaperBlock;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockRegistry {
    public static final DeferredBlock<Block> PAPER_BLOCK = BlockRegistry.register("paperblock", PaperBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).sound(SoundType.GRASS).strength(0.6f));
    public static final DeferredBlock<Block> BURNT_PAPER_BLOCK = BlockRegistry.register("burnt_paper_block", BurntPaperBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).sound(SoundType.GRAVEL).strength(0.6f));

    public static void initStatic() {
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> supplier) {
        DeferredBlock blockObject = Main.BLOCKS.register(name, supplier);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> supplier) {
        DeferredBlock blockObject = Main.BLOCKS.registerBlock(name, supplier);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> supplier, BlockBehaviour.Properties properties) {
        DeferredBlock blockObject = Main.BLOCKS.registerBlock(name, supplier, properties);
        Main.ITEMS.registerItem(name, p -> new ModBlockItem((Block)blockObject.get(), (Item.Properties)p));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> blockSupplier, Function<Block, ? extends ModBlockItem> blockItemSupplier) {
        DeferredBlock blockObject = Main.BLOCKS.register(name, blockSupplier);
        Main.ITEMS.register(name, () -> (ModBlockItem)((Object)((Object)blockItemSupplier.apply((Block)blockObject.get()))));
        return blockObject;
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Supplier<T> supplier) {
        return Main.BLOCKS.register(name, supplier);
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Function<BlockBehaviour.Properties, T> supplier) {
        return Main.BLOCKS.registerBlock(name, supplier);
    }

    private static <T extends Block> DeferredBlock<T> registerSkipTab(String name, Function<BlockBehaviour.Properties, T> supplier, BlockBehaviour.Properties properties) {
        return Main.BLOCKS.registerBlock(name, supplier, properties);
    }
}

