/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks;

import com.mojang.serialization.MapCodec;
import com.pekar.pouchandpaper.blocks.PaperBlock;
import com.pekar.pouchandpaper.blocks.entity.BlockEntityRegistry;
import com.pekar.pouchandpaper.blocks.entity.BurntPaperBlockEntity;
import com.pekar.pouchandpaper.utils.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class BurntPaperBlock
extends PaperBlock
implements EntityBlock {
    private static final MapCodec<BurntPaperBlock> CODEC = BurntPaperBlock.simpleCodec(BurntPaperBlock::new);

    public BurntPaperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        if (serverLevel.getBlockState(pos.above()).is(Blocks.FIRE)) {
            int val = randomSource.nextIntBetweenInclusive(0, 10);
            switch (val) {
                case 0: {
                    serverLevel.removeBlock(pos, false);
                    break;
                }
                case 1: {
                    serverLevel.removeBlock(pos.above(), false);
                }
            }
        }
        super.tick(blockState, serverLevel, pos, randomSource);
    }

    @Override
    public void onLand(Level level, BlockPos pos, BlockState blockState, BlockState blockState1, FallingBlockEntity fallingBlockEntity) {
        level.destroyBlock(pos, false);
    }

    @Override
    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        level.destroyBlock(pos, false);
    }

    @Override
    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof Creeper && fallDistance < 0.5f) {
            return;
        }
        if (entity instanceof Bee) {
            return;
        }
        level.destroyBlock(pos, false);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof Creeper || entity instanceof Bee) {
            return;
        }
        level.destroyBlock(pos, false);
    }

    @Override
    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    @Override
    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegistry.BURNT_PAPER_BLOCK_ENTITY.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : (level1, blockPos, blockState, blockEntity) -> ((BurntPaperBlockEntity)blockEntity).tick(level1, blockPos, blockState, (BurntPaperBlockEntity)blockEntity);
    }

    @Override
    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!Utils.instance.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            MutableComponent component = this.getDisplayName(this.asItem(), i).withStyle(ChatFormatting.DARK_GRAY);
            if (i == 1) {
                component.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
            }
            tooltipComponents.add((Component)component);
        }
    }
}

