/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks.entity;

import com.pekar.pouchandpaper.blocks.entity.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BurntPaperBlockEntity
extends BlockEntity
implements BlockEntityTicker<BurntPaperBlockEntity> {
    private static final int CREEPER_SEEK_RADUIS = 70;
    private static final int BEE_SEEK_RADUIS = 50;

    public BurntPaperBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BURNT_PAPER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void tick(Level level, BlockPos pos, BlockState blockState, BurntPaperBlockEntity burntPaperBlockEntity) {
        if (level.getGameTime() % 40L != 0L) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (level.getBlockState(pos.above()).is(Blocks.FIRE)) {
            return;
        }
        List creepers = level.getEntitiesOfClass(Creeper.class, new AABB(pos).inflate(70.0));
        for (Creeper creeper : creepers) {
            PathNavigation navigation = creeper.getNavigation();
            navigation.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
        }
        this.makeBeesAvoid(serverLevel, pos);
    }

    private void makeBeesAvoid(ServerLevel level, BlockPos pos) {
        List bees = level.getEntitiesOfClass(Bee.class, new AABB(pos).inflate(50.0));
        for (Bee bee : bees) {
            PathNavigation navigation = bee.getNavigation();
            bee.setHivePos(null);
            bee.setSavedFlowerPos(null);
            Vec3 beePos = bee.position();
            if (!navigation.isDone() && !navigation.isStuck()) continue;
            Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
            Vec3 escapeDirection = beePos.subtract(blockCenter).normalize().scale(50.0);
            Vec3 escapePosVec = beePos.add(escapeDirection);
            int escapeY = escapePosVec.y < blockCenter.y ? pos.getY() + 1 : (int)escapePosVec.y;
            BlockPos escapePos = new BlockPos((int)escapePosVec.x, escapeY, (int)escapePosVec.z);
            if (!level.getBlockState(escapePos).isAir()) continue;
            navigation.moveTo((double)escapePos.getX(), (double)escapePos.getY(), (double)escapePos.getZ(), 1.2);
        }
    }
}

