/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.pouchandpaper.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PouchOfSeedsBlockEntity
extends BlockEntity {
    private int seedsInside;

    public PouchOfSeedsBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.seedsInside = tag.getIntOr("seeds_inside", 0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveModTag(tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveModTag(tag);
        return tag;
    }

    public void setSeedsInside(int pouchesInside) {
        this.seedsInside = pouchesInside;
        this.setChanged();
    }

    public int getSeedsInside() {
        return this.seedsInside;
    }

    private void saveModTag(CompoundTag tag) {
        tag.putInt("seeds_inside", this.seedsInside);
    }
}

