package net.nml.bubble;

// import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_11515;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5619;
import net.nml.bubble.block.BubbleBlock;
import net.nml.bubble.renderer.BubbleModelFast;
// import net.nml.bubble.datagen.BubbleBlockConnectionPredicate;
import net.nml.bubble.renderer.BubbleModelMedium;
import net.nml.bubble.renderer.BubbleModelSimple;
import net.nml.bubble.renderer.BubbleModelSmall;
import net.nml.bubble.renderer.BubbleRenderer;

public class BlowingBubblesClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		// FusionPredicateRegistry.registerConnectionPredicate(Identifier.of(BlowingBubbles.MOD_ID, "bubble_block"), BubbleBlockConnectionPredicate.SERIALIZER);

		EntityModelLayerRegistry.registerModelLayer(BubbleModelFast.LAYER, BubbleModelFast::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(BubbleModelSimple.LAYER, BubbleModelSimple::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(BubbleModelSmall.LAYER, BubbleModelSmall::getTexturedModelData);
		EntityModelLayerRegistry.registerModelLayer(BubbleModelMedium.LAYER, BubbleModelMedium::getTexturedModelData);
		class_5619.method_32173(ModRegistry.BUBBLE, BubbleRenderer::new);
		HudElementRegistry.attachElementAfter(VanillaHudElements.BOSS_BAR, class_2960.method_60655(BlowingBubbles.MOD_ID, "bubble_size_indicator"), new BubbleSizeIndicatorHUD());
		ParticleFactoryRegistry.getInstance().register(ModRegistry.POP_PARTICLE, PopParticle.Factory::new);

		for (class_3545<BubbleBlock, String> pair : ModRegistry.BUBBLE_BLOCKS) {
			BubbleBlock block = pair.method_15442();
			ColorProviderRegistry.BLOCK.register((state, view, pos, i) -> block.method_10622().method_7787() % 0xffffff, block);
			BlockRenderLayerMap.putBlock(block, class_11515.field_60926);
		}
    }
}