package net.nml.bubble.datagen;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.nml.bubble.BlowingBubbles;
import net.nml.bubble.ModRegistry;
import net.nml.bubble.block.BubbleBlock;

@Environment(EnvType.CLIENT)
public class ConnectedBubbleBlockProvider extends FusionModelProvider {
	public ConnectedBubbleBlockProvider(FabricDataOutput output) {
		super(BlowingBubbles.MOD_ID, output);
	}

	@Override
	protected void generate() {
		for (class_3545<BubbleBlock, String> pair : ModRegistry.BUBBLE_BLOCKS) {
			// Block block = pair.getLeft();
			String name = pair.method_15441();
			var modelData = ConnectingModelDataBuilder.builder()
				.parent(class_2960.method_60655(BlowingBubbles.MOD_ID, "block/bubble_block"))
				.texture("all", class_2960.method_60655(BlowingBubbles.MOD_ID, "block/bubble_block"))
				.connection(DefaultConnectionPredicates.isSameBlock())
				.build();
			var modelInstance = ModelInstance.of(DefaultModelTypes.CONNECTING, modelData);
			this.addModel(class_2960.method_60655(BlowingBubbles.MOD_ID, "block/" + name), modelInstance);
		}
	}
}