package net.nml.bubble.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import net.nml.bubble.ModRegistry;

public class BubbleWandEffectsRecipe extends class_1852 {
	private static final class_1856 BUBBLE_WAND = class_1856.method_8101(ModRegistry.BUBBLE_WAND);
	private static final class_1856 DIAMOND = class_1856.method_8101(class_1802.field_8477);
	
	public BubbleWandEffectsRecipe(class_7710 craftingRecipeCategory) {
		super(craftingRecipeCategory);
	}

	public boolean matches(class_9694 craftingRecipeInput, class_1937 world) {
		if (craftingRecipeInput.method_59990() < 2) return false;
			
		boolean wand = false;
		boolean dye = false;
		boolean diamond = false;

		for (int i = 0; i < craftingRecipeInput.method_59983(); i++) {
			class_1799 itemStack = craftingRecipeInput.method_59984(i);
			if (!itemStack.method_7960()) {
				if (BUBBLE_WAND.method_8093(itemStack)) {
					if (wand) return false;
					wand = true;
				} else if (DIAMOND.method_8093(itemStack)) {
					if (dye || diamond) return false;
					diamond = true;
				} else if (itemStack.method_7909() instanceof class_1769) {
					if (diamond) return false;
					dye = true;
				} else {
					return false;
				}
			}
		}

		return (dye || diamond) && wand;
	}

	public class_1799 craft(class_9694 craftingRecipeInput, class_7225.class_7874 wrapperLookup) {
		List<class_1769> dyes = new ArrayList<class_1769>();
		class_1799 wandStack = class_1799.field_8037;
		class_1799 diamondStack = class_1799.field_8037;

		for (int i = 0; i < craftingRecipeInput.method_59983(); i++) {
			class_1799 stack = craftingRecipeInput.method_59984(i);
			if (!stack.method_7960()) {
				if (BUBBLE_WAND.method_8093(stack)) {
					if (!wandStack.method_7960()) return class_1799.field_8037;
					wandStack = stack.method_7972();
				} else if (DIAMOND.method_8093(stack)) {
					if (!dyes.isEmpty() || !diamondStack.method_7960()) return class_1799.field_8037;
					diamondStack = stack.method_7972();
				} else if (stack.method_7909() instanceof class_1769 dyeItem) {
					if (!diamondStack.method_7960()) return class_1799.field_8037;
					dyes.add(dyeItem);
				} else {
					return class_1799.field_8037;
				}
			}
		}
		if (dyes.isEmpty() && diamondStack.method_7960()) return class_1799.field_8037;

		if (diamondStack.method_7960()) {
			class_1799 outputStack = BubbleWandEffectsComponent.setColor(wandStack, dyes);
			return outputStack;
		} else {
			class_1799 outputStack = BubbleWandEffectsComponent.setRainbow(wandStack);
			return outputStack;
		}
	}

	@Override
	public class_1865<BubbleWandEffectsRecipe> method_8119() {
		return ModRegistry.BUBBLE_WAND_EFFECTS_RECIPE_SERIALIZER;
	}	
}
