package net.nml.bubble.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import net.nml.bubble.BubbleEntity;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin {
    @Inject(method = "getBlockBreakingSpeed(Lnet/minecraft/block/BlockState;)F", at = @At("RETURN"), cancellable = true)
    private void getBlockBreakingSpeed(class_2680 state, CallbackInfoReturnable<Float> cir) {
        class_1657 self = (class_1657)(Object)this;
        if (self.method_5854() instanceof BubbleEntity) {
            float speed = cir.getReturnValue();
            if (!self.method_24828()) {
                speed *= 5.0F;
            }

            if (self.method_5777(class_3486.field_15517)) {
                double waterPenalty = self.method_5996(class_5134.field_51576).method_6194();
                if (waterPenalty != 0.0) {
                    speed /= (float) waterPenalty;
                }
            }

            cir.setReturnValue(speed);
        }
    }
}
