package net.nml.bubble.renderer;

import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import net.minecraft.class_9848;
import net.nml.bubble.BlowingBubbles;
import net.nml.bubble.BubbleEntity;
import net.nml.bubble.Config;

public class BubbleRenderer extends class_922<BubbleEntity, BubbleRenderState, BubbleModelAbstract> {
	private static final class_2960 BASE_TEXTURE_FAST = class_2960.method_60655(BlowingBubbles.MOD_ID, "textures/entity/bubble/bubble_fast.png");
	private static final class_2960 BASE_TEXTURE_SIMPLE = class_2960.method_60655(BlowingBubbles.MOD_ID, "textures/entity/bubble/bubble_simple.png");
	private static final class_2960 BASE_TEXTURE_SMALL = class_2960.method_60655(BlowingBubbles.MOD_ID, "textures/entity/bubble/bubble_small.png");
	private static final class_2960 BASE_TEXTURE_MEDIUM = class_2960.method_60655(BlowingBubbles.MOD_ID, "textures/entity/bubble/bubble_medium.png");
	private static final class_2960 SHINE_TEXTURE = class_2960.method_60655(BlowingBubbles.MOD_ID, "textures/entity/bubble/shine.png");

	private final BubbleModelAbstract model_fast;
	private final BubbleModelAbstract model_simple;
	private final BubbleModelAbstract model_medium;

	public BubbleRenderer(class_5617.class_5618 ctx) {
		super(ctx, new BubbleModelSmall(ctx.method_32167(BubbleModelSmall.LAYER)), 0.0f);
		this.model_fast = new BubbleModelFast(ctx.method_32167(BubbleModelFast.LAYER));
		this.model_simple = new BubbleModelSimple(ctx.method_32167(BubbleModelSimple.LAYER));
		this.model_medium = new BubbleModelMedium(ctx.method_32167(BubbleModelMedium.LAYER));
	}

	@Override
	public void render(BubbleRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
		// shine texture
		if (state.field_53332 >= state.field_53329 * state.field_53329 / 2f) {
			float shineScale = getScale(state);
			matrices.method_22903();
			matrices.method_22905(shineScale, shineScale, shineScale);
			matrices.method_22904(0.0, 0.25, 0);
			matrices.method_22907(cameraState.field_63081);
			matrices.method_22905(0.5f, 0.5f, 0.5f);
			
			class_4587.class_4665 normalMatrix = matrices.method_23760();

			float[][] vertices = {
				{-1f, -1f, 0f, 0f, 1f},
				{1f, -1f, 0f, 1f, 1f},
				{1f, 1f, 0f, 1f, 0f},
				{-1f, 1f, 0f, 0f, 0f}
			};
			
			queue.method_73483(matrices, class_1921.method_23018(SHINE_TEXTURE, 0, 0), (entry, vertexConsumer) -> {
				for (float[] v : vertices) {
					vertexConsumer.method_56824(entry, v[0], v[1], v[2])
						.method_39415(shineColor(state))
						.method_22913(v[3], v[4])
						.method_22922(class_4608.field_21444)
						.method_60803(state.field_61820)
						.method_60831(normalMatrix, 0, 0, -1);
				}
			});
			
			matrices.method_22909(); // pop shine
		}
		
		// bubble
		float bubbleScale = getBubbleScale(state);
		matrices.method_22903();
		matrices.method_22905(bubbleScale, bubbleScale, bubbleScale);
		// this.setupTransforms(state, matrices, state.bodyYaw, bubbleScale);

		queue.method_73490(
			this.getModel(state), state, matrices,
			class_1921.method_23588(this.getTexture(state)),
			state.field_61820, class_4608.field_21444,
			bubbleColor(state), null, state.field_61821, null
		);
		
		matrices.method_22909(); // pop main
		
	}

	private int shineColor(BubbleRenderState state) {
		// float base = 0.5f * state.opacity;
		// float t = (float)state.squaredDistanceToCamera / 100f;
		return class_9848.method_61321(class_9848.method_61334(state.color), 1.5f);
	}

	private int bubbleColor(BubbleRenderState state) {
		return class_9848.method_71346(0.5f * state.opacity, state.color);
	}

	private boolean isMedium(BubbleRenderState state) {
		return Config.bubbleQuality == Config.ModelQuality.QUALITY && state.size >= 2.5f;
	}

	private float getScale(BubbleRenderState state) {
		return state.field_53453 * state.size;
	}

	private float getBubbleScale(BubbleRenderState state) {
		float scale = getScale(state);
		if (isMedium(state)) scale *= 0.5f;
		return scale;
	}

	@Override
	public class_2960 getTexture(BubbleRenderState state) {
		if (Config.bubbleQuality == Config.ModelQuality.FAST) return BASE_TEXTURE_FAST;
		if (Config.bubbleQuality == Config.ModelQuality.PLAIN) return BASE_TEXTURE_SIMPLE;
		if (isMedium(state)) return BASE_TEXTURE_MEDIUM;
		return BASE_TEXTURE_SMALL;
	}

	@Override
	protected boolean hasLabel(BubbleEntity entity, double d) {
		return false;
	}

	public BubbleModelAbstract getModel(BubbleRenderState state) {
		if (Config.bubbleQuality == Config.ModelQuality.FAST) return this.model_fast;
		if (Config.bubbleQuality == Config.ModelQuality.PLAIN) return this.model_simple;
		if (isMedium(state)) return this.model_medium;
		return this.field_4737;
	}

	@Override
	public BubbleRenderState method_55269() {
		return new BubbleRenderState();
	}
	
	public void updateRenderState(BubbleEntity entity, BubbleRenderState state, float tickDelta) {
		super.method_62355(entity, state, tickDelta);
        state.size = entity.getSize();
        state.opacity = entity.getOpacity();
		state.color = entity.getColor();
		state.field_53332 = this.field_4676.field_4686.method_19326().method_1025(entity.method_73189().method_1031(0, entity.method_17682() / 2f, 0));
	}
}
