package net.nml.bubble;

import java.util.Collection;
import java.util.Optional;

import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import net.minecraft.class_9848;
import net.nml.bubble.block.BubbleBlock;

public class BubbleEntity extends class_1309 {
	private class_1844 potion = class_1844.field_49274;
	private static final class_2940<Integer> COLOR = class_2945.method_12791(BubbleEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> CUSTOM_COLOR = class_2945.method_12791(BubbleEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> TIME = class_2945.method_12791(BubbleEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> DURATION = class_2945.method_12791(BubbleEntity.class, class_2943.field_13327);
	private static final class_2940<Float> SIZE = class_2945.method_12791(BubbleEntity.class, class_2943.field_13320);
	private static final class_2940<Float> OPACITY = class_2945.method_12791(BubbleEntity.class, class_2943.field_13320);
	private static final class_2940<Boolean> HAS_ENTITY_ON_TOP = class_2945.method_12791(BubbleEntity.class, class_2943.field_13323);
	protected static final class_2940<Optional<class_10583<class_1309>>> OWNER_UUID = class_2945.method_12791(BubbleEntity.class, class_2943.field_55584);
	
	public BubbleEntity(class_1299<? extends BubbleEntity> entityType, class_1937 world) {
		super(entityType, world);
		this.setDuration(randomDuration());
		this.method_5710(this.field_5974.method_43057() * 360.0F, 0);
		this.updateColor();
	}

	public BubbleEntity(class_1937 world, float size) {
		this(ModRegistry.BUBBLE, world);
		this.setSize(size);
		this.setDuration(randomDuration());
	}

	@Override
	public void method_5773() {
		if (this.method_29504()) {
			if (!this.method_37908().field_9236) {
				((class_3218) this.method_37908()).method_65096(new PopParticleEffect(this.getColor(), this.getSize()), 
				this.method_23317(), this.method_23318() + 0.25, this.method_23321(),
				1, 0, 0, 0, 0);
			}
			this.method_5650(class_1297.class_5529.field_26998);
			return;
		}
		
		super.method_5773();
		if (this.method_37908().field_9236) return;
		this.method_5855(0);

		int duration = this.getDuration();

		if (duration > 0) {
			int v = 0;
			if (!this.method_5782()) {
				v++;
				if (!this.hasEntityOnTop()) v++;
				if (this.field_5976 ||	this.field_5992) v++;
				this.setTime(this.getTime() + v);
			} else if (this.method_59922().method_43056()) {
				this.setTime(this.getTime() + 1);
			}

			if (this.getTime() >= duration) {
				this.method_6033(0);
				this.setOpacity(0);
			} else {
				this.method_6033((duration - this.getTime()) / 40f);
				this.setOpacity((duration - this.getTime()) / (float) duration);
			}
		}
	}
	
	@Override
	protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
		super.method_49481(controllingPlayer, movementInput);
		this.method_5710(controllingPlayer.method_36454(), controllingPlayer.method_36455() * 0.5F);
		this.field_5982 = this.field_6283 = this.field_6241 = this.method_36454();
		controllingPlayer.method_5855(controllingPlayer.method_5669() + 2);
		this.applyEffects(controllingPlayer);
	}

	@Override
	protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
		if (this.method_5799()) {
			float r = controllingPlayer.method_36455() * (float) (Math.PI / 180.0);
			return new class_243(
				controllingPlayer.field_6212,
				-class_3532.method_15374(r) * controllingPlayer.field_6250 + (controllingPlayer.method_70673() ? 0.5f : 0f),
				class_3532.method_15362(r) * controllingPlayer.field_6250
			);
		}
		return new class_243(controllingPlayer.field_6212, 0, controllingPlayer.field_6250);
	}

	@Nullable
	@Override
	public class_1309 method_5642() {
		return this.method_31483() instanceof class_1657 player ? player : super.method_5642();
	}
	
	@Override
	public boolean method_30948(@Nullable class_1297 entity) {
		boolean r = entity != null && this.canEntityInteract(entity) && this.canEntityStand(entity, (float)this.method_18798().field_1351);
		this.field_6011.method_12778(HAS_ENTITY_ON_TOP, r);
		return r;
	}

	@Override
	public boolean method_5810() {
		return true;
	}

	@Override
	public void method_5697(class_1297 entity) {
		if (!this.canEntityInteract(entity) || this.method_37908().field_9236) return;
		if (this.canEntityStand(entity, entity.method_49476())) {
			// TODO 1.1
		} else if (this.canEntityEnter(entity)) {
			entity.method_5873(this, true);
		} else {
			// double v = MathHelper.clamp(Math.max(entity.getHeight(), entity.getWidth()) - this.getWidth(), 0.0, 1.0);
			// this.setTime(v == 1.0 ? this.getDuration() : this.getTime() + (int)(100 * v));
			this.setTime(this.getDuration());
			entity.method_5855(entity.method_5748());
		}
	}

	@Override
	protected void method_6087(class_1297 entity) {
	}

	public boolean canEntityInteract(class_1297 entity) {
		return !entity.field_5960 && entity.method_5709() && !entity.method_5765() && !(entity instanceof BubbleEntity);
	}
	public boolean canEntityStand(class_1297 entity, float stepHeight) {
		return entity.method_17681() < this.method_17681() && entity.method_23318() + stepHeight >= this.method_23318() + this.method_17682();
	}
	public boolean canEntityEnter(class_1297 entity) {
		return Math.max(entity.method_17682(), entity.method_17681()) + 0.1 <= this.method_17681() && !this.method_5782();
	}

	public boolean hasEntityOnTop() {
		return this.field_6011.method_12789(HAS_ENTITY_ON_TOP);
	}

	@Override
	public class_243 method_52538(class_1297 entity) {
		// Place the passenger in the vertical center of the bubble
		double bubbleCenterY = this.method_19538().field_1351 + (this.method_17682());
		double passengerHalfHeight = entity.method_17682() / 2.0;
		return new class_243(this.method_19538().field_1352, bubbleCenterY - passengerHalfHeight, this.method_19538().field_1350);
	}

	@Override
	public boolean method_64397(class_3218 world, class_1282 source, float amount) {
		if (this.method_5679(world, source) || this.method_29504()) {
			return false;
		}
		this.setTime(this.getDuration());
		if (this.getTime() <= 0) {
			this.method_6033(0);
		}
		return true;
	}
	
	@Override
	public boolean method_6049(class_1293 effect) {
		return false;
	}
	
	@Override
	public boolean method_37222(class_1293 effect, class_1297 source) {
		return this.addEffect(effect);
	}

	public boolean addEffect(class_1293 effect) {
		class_1293 statusEffectInstance = null;
		for (class_1293 e : this.potion.method_57397()) {
			if (e.method_5579().equals(effect.method_5579())) {
				statusEffectInstance = e;
				break;
			}
		}
		if (statusEffectInstance != null) {
			if (!statusEffectInstance.method_5590(effect)) return false;

			this.setPotionContents(class_1844.field_49274);
			for (class_1293 e : this.potion.method_57397()) {
				if (!e.method_5579().equals(effect.method_5579())) {
					this.setPotionContents(this.potion.method_57398(e));
				}
			}
			return true;
		}
		this.setPotionContents(this.potion.method_57398(effect));
		return true;
	}

	public void setEffects(Collection<class_1293> collection) {
		for (class_1293 statusEffectInstance : collection) {
			this.setPotionContents(this.potion.method_57398((new class_1293(statusEffectInstance))));
		}
	}

	public void applyEffects(class_1309 entity) {
		this.potion.method_62839(entity, this.getOpacity());
	}

	public void setPotionContents(class_1844 potionContentsComponent) {
		this.potion = potionContentsComponent;
		this.updateColor();
	}

	public void updateColor() {
		int cc = this.field_6011.method_12789(CUSTOM_COLOR);
		if (cc == 16) {
			this.setColor(this.potion.method_65361(this.getCustomColor()));
		} else {
			this.setColor(class_9848.method_61322(this.getCustomColor(), this.potion.method_65361(-1)));
		}
	}

	public BubbleBlock getBubbleBlock() {
		float maxDistance = Float.MAX_VALUE;
		BubbleBlock block = null;

		Vector3f colorVector = class_9848.method_64963(this.getColor());
		for (class_3545<BubbleBlock, String> pair : ModRegistry.BUBBLE_BLOCKS) {
			int blockColor = pair.method_15442().method_10622().method_7787();
			float distance = class_9848.method_64963(blockColor).distance(colorVector);
			if (distance < maxDistance) {
				maxDistance = distance;
				block = pair.method_15442();
			}
		};
		return block;
	}

	private int randomDuration() {
		return 40 * (7 + this.field_5974.method_43048(6)) + (int)((this.getSize() - 1f) * 20);
	}

	public void setDuration(int duration) {
		this.field_6011.method_12778(DURATION, duration);
	}

	public int getTime() {
		return this.field_6011.method_12789(TIME);
	}

	public void setTime(int time) {
		this.field_6011.method_12778(TIME, time);
	}					

	public int getDuration() {
		return this.field_6011.method_12789(DURATION);
	}

	public void setSize(float size) {
		this.field_6011.method_12778(SIZE, size);
	}

	public float getSize() {
		return this.field_6011.method_12789(SIZE);
	}

	private void setColor(int color) {
		this.field_6011.method_12778(COLOR, color);
	}

	public int getColor() {
		return this.field_6011.method_12789(COLOR);
	}

	public void setCustomColor(int color) {
		this.field_6011.method_12778(CUSTOM_COLOR, color);
		this.updateColor();
	}

	public static int getDefaultColor() {
		return class_9848.method_61323(80, 200, 255);
	}

	public int getCustomColor() {
		int cc = this.field_6011.method_12789(CUSTOM_COLOR);
		return cc == 16 ? getDefaultColor() : cc;
	}

	public void setOpacity(float opacity) {
		this.field_6011.method_12778(OPACITY, class_3532.method_15363(opacity, 0.2f, 1.0f));
	}

	// aka percentage to pop, with min at 0.2f
	public float getOpacity() {
		return this.field_6011.method_12789(OPACITY);
	}
	
	public void setOwner(@Nullable class_1309 owner) {
		this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(owner).map(class_10583::new));
	}

	@Nullable
	public class_10583<class_1309> getOwnerReference() {
		return (class_10583<class_1309>)this.field_6011.method_12789(OWNER_UUID).orElse(null);
	}
	
	@Override
	public class_4048 method_55694(class_4050 pose) {
		return super.method_55694(pose).method_18383(this.getSize());
	}

	@Override
	protected double method_7490() {
		if (this.method_5782() && this.method_5799()) return 0.0;
		double g = -0.005;
		if (this.method_5799()) g -= 0.005;
		if (this.hasEntityOnTop() || this.method_5782()) g += 0.01;
		if (this.method_70668()) g += 0.008;
		g += (this.getSize() - 2f) * 0.0025;
		return class_3532.method_15350(g, -0.1, 0.1);
	}
	
	@Override
	public void method_6091(class_243 movementInput) {
		double drag = this.method_5799() ? 0.9 : 0.98;
		double dragX = this.hasEntityOnTop() ? 0.7 : this.method_5782() ? drag * 0.95 : drag;
		this.method_5724(0.02f, movementInput);
		this.method_18799(this.method_18798().method_1031(0, -method_7490(), 0).method_18805(dragX, drag, dragX));
		this.method_5784(class_1313.field_6308, method_18798());
	}

	@Override
	public boolean method_29920() {
		return false;
	}

	@Override
	protected float method_23326() {
		return 1f; // modified in travel()
	}

	@Override
	protected void method_5622(class_2680 state) {
		super.method_5622(state);
		if (!this.method_37908().field_9236 && state.method_27852(class_2246.field_21211)) {
			this.setTime(this.getTime() + 2);
			this.method_18799(this.method_18798().method_1021(0.5));
			if (this.getTime() >= this.getDuration() - 10) {
				this.method_37908().method_8649(new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), new class_1799(this.getBubbleBlock())));
				this.method_5650(class_1297.class_5529.field_26998);
			}
		}
	}
	
	@Override
	protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
	}

	@Override
	protected class_1297.class_5799 method_33570() {
		return class_1297.class_5799.field_28630;
	}

	@Override
	public boolean method_35053() {
		return true;
	}

	public static class_5132.class_5133 method_26827() {
		return class_1309.method_26827();
	}

	@Override
	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(HAS_ENTITY_ON_TOP, false);
		builder.method_56912(OPACITY, 1.0f);
		builder.method_56912(SIZE, 1.0f);
		builder.method_56912(TIME, 0);
		builder.method_56912(DURATION, 0);
		builder.method_56912(COLOR, 0);
		builder.method_56912(CUSTOM_COLOR, 16);
		builder.method_56912(OWNER_UUID, Optional.empty());
	}

	@Override
	public void method_5674(class_2940<?> data) {
		if (SIZE.equals(data)) {
			this.method_18382();
		}

		super.method_5674(data);
	}

	@Override
	protected void method_5652(class_11372 view) {
		super.method_5652(view);
		view.method_71465("pop_time", this.getTime());
		view.method_71465("Duration", this.getDuration());
		view.method_71464("Size", this.getSize());
		if (this.field_6011.method_12789(CUSTOM_COLOR) != 16) {
			view.method_71465("CustomColor", this.getCustomColor());
		}
		if (!this.potion.equals(class_1844.field_49274)) {
			view.method_71468("potion_contents", class_1844.field_49275, this.potion);
		}

		class_10583.method_71612(this.getOwnerReference(), view, "Owner");
	}

	@Override
	protected void method_5749(class_11368 view) {
		super.method_5749(view);
		this.setTime(view.method_71424("pop_time", 0));
		this.field_6011.method_12778(SIZE, view.method_71423("Size", 1));

		Optional<Integer> duration = view.method_71439("Duration");
		if (duration.isPresent()) this.setDuration(duration.get());

		Optional<Integer> color = view.method_71439("CustomColor");
		if (color.isPresent()) {
			if (color.get() == 16) this.setCustomColor(rainbowColor(this.field_5974));
			else this.setCustomColor(color.get());
		}

		class_10583<class_1309> lazyEntityReference = class_10583.method_66260(view, "Owner", this.method_37908());
		if (lazyEntityReference != null) {
			try {
				this.field_6011.method_12778(OWNER_UUID, Optional.of(lazyEntityReference));
			} catch (Throwable t) {}
		} else {
			this.field_6011.method_12778(OWNER_UUID, Optional.empty());
		}

		this.setPotionContents((class_1844)view.method_71426("potion_contents", class_1844.field_49275).orElse(class_1844.field_49274));
	}

	public static int rainbowColor(class_5819 random) {
        float hue = random.method_43057();
        float saturation = 0.4f + random.method_43057() * 0.3f;
        float brightness = 0.7f + random.method_43057() * 0.3f;
        return class_3532.method_15369(hue, saturation, brightness);
    }
	public static int rainbowColor(float t) {
		float hue = Math.abs(t % 3600) / 3600;
        float saturation = 0.55f;
        float brightness = 0.85f;
        return class_3532.method_15369(hue, saturation, brightness);
    }

	@Override
	public class_1306 method_6068() {
		return class_1306.field_6183;
	}
}
