package net.nml.bubble;

import org.joml.Vector3f;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9848;

public class PopParticleEffect implements class_2394 {
	protected static final Codec<Float> SCALE_CODEC = Codec.FLOAT;
	public static final PopParticleEffect DEFAULT = new PopParticleEffect(16711680, 1.0F);
	public static final MapCodec<PopParticleEffect> CODEC = RecordCodecBuilder.mapCodec(
		instance -> instance.group(
				class_5699.field_54067.fieldOf("color").forGetter(p -> p.color),
				SCALE_CODEC.fieldOf("scale").forGetter(PopParticleEffect::getScale)
			)
			.apply(instance, PopParticleEffect::new)
	);
	public static final class_9139<class_9129, PopParticleEffect> PACKET_CODEC = class_9139.method_56435(
		class_9135.field_49675, p -> p.color,
		class_9135.field_48552, PopParticleEffect::getScale,
		PopParticleEffect::new
	);

	private final float scale;
	private final int color;

	public PopParticleEffect(int color, float scale) {
		this.color = color;
		this.scale = scale;
	}

	@Override
	public class_2396<?> method_10295() {
		return ModRegistry.POP_PARTICLE;
	}

	public Vector3f getColor() {
		return class_9848.method_64963(this.color);
	}

	public float getScale() {
		return this.scale;
	}	
}
