package net.nml.bubble.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import net.nml.bubble.BlowingBubbles;
import net.nml.bubble.BubbleEntity;
import net.nml.bubble.ModRegistry;

public class BubbleWandItem extends class_1792 {
	public BubbleWandItem(class_1793 settings) {
		super(settings);
	}

	@Override
	public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
		int useTicks = this.getUseTicks(remainingUseTicks, stack, user);
		if (user instanceof class_1657 playerEntity) {
			playerEntity.method_7259(class_3468.field_15372.method_14956(this));
			if (!playerEntity.method_56992()) {
				stack.method_61653(1, playerEntity);
				playerEntity.method_7357().method_62835(stack, this.getCooldownTicks(useTicks));
			}
		}
		
		if (BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BUBBLE_BARRAGE_ENCHANTMENT_EFFECT) != -1) {
			this.method_7852(world, user, stack, remainingUseTicks);
		} else {
			if (world instanceof class_3218 serverWorld) {
				this.shoot(user, serverWorld, stack, this.getSize(useTicks, stack), 0.1);
			}
		}
		return true;
	}

	public void shoot(class_1309 user, class_3218 world, class_1799 stack, float size, double speed) {
		BubbleEntity bubble = new BubbleEntity(world, size);
		bubble.method_5814(user.method_23317(), user.method_23320() - bubble.method_17682() / 2, user.method_23321());
		
		float pitch = user.method_36455();
		float yaw = user.method_36454();

		double spread = class_3532.method_15350(speed * 20.0, 0.0, 10.0);
		if (spread > 0.0) {
			float randomYaw = (float)(world.method_8409().method_43059() * spread);
			float randomPitch = (float)(world.method_8409().method_43059() * spread);
			yaw += randomYaw;
			pitch += randomPitch;
		}
		
		double x = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
		double y = -Math.sin(Math.toRadians(pitch));
		double z = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
		
		// TODO 1.1: add same mechanic as arrows to not hit the shooter
		bubble.method_18800(x * speed, y * speed, z * speed);
		bubble.method_33574(bubble.method_19538().method_1019(bubble.method_18798().method_1021(size * 6)));
		bubble.method_18382();

		if (BubbleWandEffectsComponent.getColor(stack).isPresent()) {
			bubble.setCustomColor(BubbleWandEffectsComponent.getColor(stack).get());
		} else if (BubbleWandEffectsComponent.getRainbow(stack)) {
			bubble.setCustomColor(BubbleEntity.rainbowColor(bubble.method_59922()));
		}
		bubble.setEffects(user.method_6026());
		bubble.setOwner(user);
		if (BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.INFINITE_BUBBLE_ENCHANTMENT_EFFECT) != -1) {
			List<BubbleEntity> list = new ArrayList<>();
			world.method_47539(class_5575.method_31795(BubbleEntity.class), (e) -> e.getDuration() == 0 && e.getOwnerReference().method_66256(user), list, 1);
			if (!list.isEmpty()) list.getFirst().method_5768(world);
			bubble.setDuration(0);
		}
		
		world.method_8649(bubble);
		world.method_43128(
			null,
			user.method_23317(),
			user.method_23318(),
			user.method_23321(),
			class_3417.field_14600,
			class_3419.field_15248,
			1.0F,
			1.0F
		);
	}

	public float getMaxBlowableSize(class_1799 stack) {
		if (BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BUBBLE_BARRAGE_ENCHANTMENT_EFFECT) != -1) return 1.0f;
		int i = BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BIGGER_BUBBLES_ENCHANTMENT_EFFECT);
		if (i != -1) return 5.0f + i * 1.5f;
		return 5.0f;
	}

	public float getSizePerTick(class_1799 stack) {
		int i = BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BIGGER_BUBBLES_ENCHANTMENT_EFFECT);
		if (i != -1) return class_3532.method_15363(20.0f - i * 2f, 1f, 20f);
		return 20.0f;
	}

	public int getUseTicks(int useTicks, class_1799 stack) {
		return class_3532.method_15340(useTicks, 0, (int)((this.getMaxBlowableSize(stack) - 1) * this.getSizePerTick(stack)));
	}

	public int getUseTicks(int remainingUseTicks, class_1799 stack, class_1309 user) {
		return this.getUseTicks(this.method_7881(stack, user) - remainingUseTicks, stack);
	}

	public float getSize(int useTicks, class_1799 stack) {
		return 1f + useTicks / this.getSizePerTick(stack);
	}

	public int getCooldownTicks(int useTicks) {
		return 10 + useTicks / 2;
	}
	
	@Override
	public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
		user.method_6019(hand);
		return class_1269.field_21466;
	}

	@Override
	public int method_7881(class_1799 stack, class_1309 user) {
		return 72000;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
		if (BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BUBBLE_BARRAGE_ENCHANTMENT_EFFECT) == -1) return;
		if (remainingUseTicks % 2 != 0) return;

		if (world instanceof class_3218 serverWorld) {
			float s = 1f;
			int i = BlowingBubbles.getEnchantmentLevel(stack, ModRegistry.BIGGER_BUBBLES_ENCHANTMENT_EFFECT);
			if (i != -1) s += i * 0.5f;
			this.shoot(user, serverWorld, stack, s, 0.2);
		}
	}
	
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8949;
	}

	@Override
	@SuppressWarnings("deprecation")
	public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent,
			Consumer<class_2561> textConsumer, class_1836 type) {
		super.method_67187(stack, context, displayComponent, textConsumer, type);
		// what was the point of this? ig im missing something
		stack.method_57369(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT, context, displayComponent, textConsumer, type);
	}
}
