package net.nml.bubble;

import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import net.nml.bubble.item.BubbleWandItem;

public class BubbleSizeIndicatorHUD implements HudElement {
	private static final class_2960 PIXEL_TEXTURE = class_2960.method_60655(BlowingBubbles.MOD_ID, "pixel");

	@Override
	public void render(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();

		if (!client.field_1690.method_31044().method_31034()) return;

        class_1799 stack = client.field_1724.method_6030();
        if (!(stack.method_7909() instanceof BubbleWandItem wand)) return;
        if (!client.field_1724.method_6115()) return;

        float size = wand.getSize(wand.getUseTicks(client.field_1724.method_6048(), stack), stack);
		int radius = (int)(size * 5);

		int x = (context.method_51421() - 1) / 2;
		int y = (context.method_51443() - 1) / 2;

		drawCircle(context, x, y, radius);

		if (client.method_53526().method_53536()) {
			String text = String.format("%.1f", size);
			int textWidth = client.field_1772.method_1727(text);
			context.method_51433(client.field_1772, text, x - (textWidth / 2), y + 2 + radius, 0xeeeeeeff, true);
		}
	}
	private void drawCircle(class_332 context, int cx, int cy, int radius) {
		int x = radius;
        int y = 0;
        int d = 1 - radius;

        while (x >= y) {
			drawPixel(context, cx + x, cy + y);
			drawPixel(context, cx - x, cy - y);
			if (x > y) {
				drawPixel(context, cx + y, cy + x);
				drawPixel(context, cx - y, cy - x);
			}
            if (y > 0) {
				drawPixel(context, cx - x, cy + y);
				drawPixel(context, cx + x, cy - y);
				if (x > y) {
					drawPixel(context, cx - y, cy + x);
					drawPixel(context, cx + y, cy - x);
				}
			}

            y++;

            if (d < 0) {
                d += 2 * y + 1;
            } else {
                x--;
                d += 2 * (y - x) + 1;
            }
        }
	}
	
	private void drawPixel(class_332 context, int x, int y) {
		context.method_52706(class_10799.field_56890, PIXEL_TEXTURE, x, y, 1, 1);
		// context.fill(RenderPipelines.CROSSHAIR, x, y, x + size, y + size, color);
	}
	
}
