package net.nml.bubble;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.mojang.serialization.Codec;

import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3902;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.minecraft.class_9723;
import net.nml.bubble.block.BubbleBlock;
import net.nml.bubble.block.BubbleDispenserBlock;
import net.nml.bubble.block.BubbleDispenserBlockEntity;
import net.nml.bubble.item.BubbleWandEffectsComponent;
import net.nml.bubble.item.BubbleWandEffectsRecipe;
import net.nml.bubble.item.BubbleWandItem;

public class ModRegistry {
	public static final class_1299<BubbleEntity> BUBBLE = entity("bubble",
		class_1299.class_1300.<BubbleEntity>method_5903(BubbleEntity::new, class_1311.field_6294)
			.method_17687(0.4f, 0.4f));

	public static final class_1792 BUBBLE_WAND = item("bubble_wand", BubbleWandItem::new,
		new class_1792.class_1793()
			.method_7889(1)
			.method_7895(250)
			.method_61649(1)
			.method_61647(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "ingots/copper"))));

	public static final List<class_3545<BubbleBlock, String>> BUBBLE_BLOCKS = new ArrayList<>();
	public static final class_2248 WHITE_BUBBLE_BLOCK = bubbleBlock("white_bubble_block", class_1767.field_7952);
	public static final class_2248 LIGHT_GRAY_BUBBLE_BLOCK = bubbleBlock("light_gray_bubble_block", class_1767.field_7967);
	public static final class_2248 GRAY_BUBBLE_BLOCK = bubbleBlock("gray_bubble_block", class_1767.field_7944);
	public static final class_2248 BLACK_BUBBLE_BLOCK = bubbleBlock("black_bubble_block", class_1767.field_7963);
	public static final class_2248 BROWN_BUBBLE_BLOCK = bubbleBlock("brown_bubble_block", class_1767.field_7957);
	public static final class_2248 RED_BUBBLE_BLOCK = bubbleBlock("red_bubble_block", class_1767.field_7964);
	public static final class_2248 ORANGE_BUBBLE_BLOCK = bubbleBlock("orange_bubble_block", class_1767.field_7946);
	public static final class_2248 YELLOW_BUBBLE_BLOCK = bubbleBlock("yellow_bubble_block", class_1767.field_7947);
	public static final class_2248 LIME_BUBBLE_BLOCK = bubbleBlock("lime_bubble_block", class_1767.field_7961);
	public static final class_2248 GREEN_BUBBLE_BLOCK = bubbleBlock("green_bubble_block", class_1767.field_7942);
	public static final class_2248 CYAN_BUBBLE_BLOCK = bubbleBlock("cyan_bubble_block", class_1767.field_7955);
	public static final class_2248 LIGHT_BLUE_BUBBLE_BLOCK = bubbleBlock("light_blue_bubble_block", class_1767.field_7951);
	public static final class_2248 BLUE_BUBBLE_BLOCK = bubbleBlock("blue_bubble_block", class_1767.field_7966);
	public static final class_2248 PURPLE_BUBBLE_BLOCK = bubbleBlock("purple_bubble_block", class_1767.field_7945);
	public static final class_2248 MAGENTA_BUBBLE_BLOCK = bubbleBlock("magenta_bubble_block", class_1767.field_7958);
	public static final class_2248 PINK_BUBBLE_BLOCK = bubbleBlock("pink_bubble_block", class_1767.field_7954);

	public static final class_2248 BUBBLE_DISPENSER = block("bubble_dispenser", BubbleDispenserBlock::new,
		class_4970.class_2251.method_9637()
			.method_31710(class_3620.field_16023)
			.method_51368(class_2766.field_12653)
			.method_29292()
			.method_9632(3.5f),
			true);

	public static final class_2591<BubbleDispenserBlockEntity> BUBBLE_DISPENSER_BLOCK_ENTITY = blockEntityType("bubble_dispenser", FabricBlockEntityTypeBuilder.<BubbleDispenserBlockEntity>create(BubbleDispenserBlockEntity::new, BUBBLE_DISPENSER).build());

	public static class_9331<class_3902> BUBBLE_BARRAGE_ENCHANTMENT_EFFECT = enchantmentEffect("bubble_barrage", class_3902.field_51563);
	public static class_9331<class_3902> INFINITE_BUBBLE_ENCHANTMENT_EFFECT = enchantmentEffect("infinite_bubble", class_3902.field_51563);
	public static class_9331<class_9723> BIGGER_BUBBLES_ENCHANTMENT_EFFECT = enchantmentEffect("bigger_bubbles", class_9723.field_51709);
	// public static ComponentType<EnchantmentValueEffect> STRONGER_BUBBLES_ENCHANTMENT_EFFECT = enchantmentEffect("stronger_bubbles", EnchantmentValueEffect.CODEC);

	public static final class_1865<BubbleWandEffectsRecipe> BUBBLE_WAND_EFFECTS_RECIPE_SERIALIZER = class_2378.method_10230(class_7923.field_41189, 
		class_2960.method_60655(BlowingBubbles.MOD_ID, "special_bubble_wand_effects"), new class_1852.class_1866<>(BubbleWandEffectsRecipe::new));
	public static final class_9331<BubbleWandEffectsComponent> BUBBLE_WAND_EFFECTS_COMPONENT = class_2378.method_10230(
		class_7923.field_49658,
		class_2960.method_60655(BlowingBubbles.MOD_ID, "bubble_wand_effects"),
		class_9331.<BubbleWandEffectsComponent>method_57873().method_57881(BubbleWandEffectsComponent.CODEC).method_57882(BubbleWandEffectsComponent.PACKET_CODEC).method_57880()
	);

	public static final class_2396<PopParticleEffect> POP_PARTICLE = particle("pop", FabricParticleTypes.complex(false, p -> PopParticleEffect.CODEC, p -> PopParticleEffect.PACKET_CODEC));


	private static <T> class_5321<T> key(class_2378<T> registry, String name) {
		return class_5321.method_29179(registry.method_46765(), class_2960.method_60655(BlowingBubbles.MOD_ID, name));
	}

	private static <T extends class_1297> class_1299<T> entity(String name, class_1299.class_1300<T> builder) {
		return class_2378.method_10230(
			class_7923.field_41177,
			class_2960.method_60655(BlowingBubbles.MOD_ID, name),
			builder.method_5905(key(class_7923.field_41177, name))
		);
	}

	private static class_1792 item(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
		return class_1802.method_51348(key(class_7923.field_41178, name), factory, settings);
	}

	private static class_2248 block(String name, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings, boolean hasItem) {
		class_5321<class_2248> blockKey = key(class_7923.field_41175, name);
		class_2248 block = blockFactory.apply(settings.method_63500(blockKey));

		if (hasItem) {
			class_5321<class_1792> itemKey = key(class_7923.field_41178, name);
			class_1747 blockItem = new class_1747(block, new class_1792.class_1793().method_63686(itemKey));
			class_2378.method_39197(class_7923.field_41178, itemKey, blockItem);
		}

		return class_2378.method_39197(class_7923.field_41175, blockKey, block);
	}

	private static class_2248 bubbleBlock(String name, class_1767 color) {
		class_2248 block = block(name, settings -> new BubbleBlock(color, settings),
			class_4970.class_2251.method_9637()
				.method_9618() // TODO: temp, it crashes otherwise
				.method_9626(class_2498.field_11545) // TODO: temp
				.method_51368(class_2766.field_12645)
				.method_50012(class_3619.field_15971)
				.method_51369()
				.method_22488()
				.method_45477()
				.method_26235(class_2246::method_26114)
				.method_26243(class_2246::method_26122)
				.method_26245(class_2246::method_26122),
				true);
		if (block instanceof BubbleBlock bubbleBlock) {
			BUBBLE_BLOCKS.add(new class_3545<BubbleBlock, String>(bubbleBlock, name));
		}

		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059).register(content -> content.method_45421(block.method_8389()));
		return block;
	}

	private static <T extends class_2591<?>> T blockEntityType(String path, T blockEntityType) {
	  return class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(BlowingBubbles.MOD_ID, path), blockEntityType);
	}

	// private static RegistryKey<Enchantment> enchantment(String name) {
	// 	return RegistryKey.of(RegistryKeys.ENCHANTMENT, Identifier.of(BlowingBubbles.MOD_ID, name));
	// }

	private static <T> class_9331<T> enchantmentEffect(String name, Codec<T> codec) {
		// this is probably incorrect :shrug:
		return class_2378.method_10230(class_7923.field_51832, class_2960.method_60655(BlowingBubbles.MOD_ID, name), class_9331.<T>method_57873().method_57881(codec).method_57880());
	}

	private static <T extends class_2394> class_2396<T> particle(String name, class_2396<T> p) {
		class_2378.method_10230(class_7923.field_41180, class_2960.method_60655(BlowingBubbles.MOD_ID, name), p);
		return p;
	}


	public static void initialize() {
		FabricDefaultAttributeRegistry.register(BUBBLE, BubbleEntity.method_26827());
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> content.method_45421(BUBBLE_WAND));
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40198).register(content -> content.method_45421(BUBBLE_DISPENSER.method_8389()));

		MidnightConfig.init(BlowingBubbles.MOD_ID, Config.class);
	}
}
