package net.nml.bubble.block;

import org.jetbrains.annotations.Nullable;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import net.nml.bubble.BubbleEntity;

public class BubbleDispenserBlock extends class_2237 {
	public static final MapCodec<BubbleDispenserBlock> CODEC = method_54094(BubbleDispenserBlock::new);
	public static final class_2754<class_2350> FACING = class_2318.field_10927;
	public static final class_2746 POWERED = class_2741.field_12484;
	public static final class_2758 PROGRESS = class_2741.field_12517;

	@Override
	protected MapCodec<? extends class_2237> method_53969() {
		return field_46280;
	}
	
	public BubbleDispenserBlock(class_2251 settings) {
		super(settings);
		this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(POWERED, false).method_11657(PROGRESS, 0));
	}

	@Override
	protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
		if (!world.field_9236) {
			// TODO: spam protection
			this.dispense(world, pos, state, state.method_11654(PROGRESS), player.method_59922());
			world.method_8501(pos, state.method_11657(PROGRESS, 0));
		}

		return class_1269.field_5812;
	}

	@Override
	protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
		boolean powered = world.method_49803(pos) || world.method_49803(pos.method_10084());
		boolean prevPowered = state.method_11654(POWERED);
		if (powered && !prevPowered) {
			if (!world.method_8397().method_8677(pos, this)) {
				world.method_64310(pos, this, 2);
			}
			world.method_8652(pos, state.method_11657(POWERED, true).method_11657(PROGRESS, 1), class_2248.field_31028);
		} else if (!powered && prevPowered) {
			world.method_8652(pos, state.method_11657(POWERED, false), class_2248.field_31028);
		}
	}

	@Override
	protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		this.update(world, state, pos, random);
	}

	private void update(class_1937 world, class_2680 state, class_2338 pos, class_5819 random) {
		boolean powered = state.method_11654(POWERED);
		int progress = state.method_11654(PROGRESS);
		world.method_64310(pos, this, 2);
		if (powered && progress < 25) {
			world.method_8501(pos, state.method_11657(PROGRESS, progress + 1));
			return;
		} else if (!powered && progress == 0) {
			return;
		}
		this.dispense(world, pos, state, progress, random);
		world.method_8501(pos, state.method_11657(PROGRESS, 0));
	}

	public void dispense(class_1937 world, class_2338 pos, class_2680 state, int progress, class_5819 random) {
		float size = 1f + progress / 6f;
		double speed = 0.3 + Math.abs(random.method_43059()) * 0.1;
		class_2350 direction = state.method_11654(FACING);
		
		BubbleEntity bubble = new BubbleEntity(world, size);
		bubble.method_33574(pos.method_10079(direction, 1).method_46558());
		
		double x = (direction.method_10148() + random.method_43059() * 0.1) * 0.4;
		double y = (direction.method_10164() + random.method_43059() * 0.1) * 0.4;
		double z = (direction.method_10165() + random.method_43059() * 0.1) * 0.4;
		
		bubble.method_18800(x * speed, y * speed, z * speed);
		bubble.method_18382();

		// TODO: bubble effects
		// if (BubbleWandEffectsComponent.getColor(stack).isPresent()) {
		// 	bubble.setCustomColor(BubbleWandEffectsComponent.getColor(stack).get());
		// } else if (BubbleWandEffectsComponent.getRainbow(stack)) {
		// 	bubble.setCustomColor(BubbleEntity.rainbowColor(bubble.getRandom()));
		// }
		
		world.method_8649(bubble);
		world.method_43128(
			null,
			pos.method_10263(),
			pos.method_10264(),
			pos.method_10260(),
			class_3417.field_14600,
			class_3419.field_15245,
			0.2F,
			1.0F
		);
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new BubbleDispenserBlockEntity(pos, state);
	}

	@Override
	public class_2680 method_9605(class_1750 ctx) {
		return this.method_9564().method_11657(FACING, ctx.method_7715().method_10153());
	}

	@Override
	protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
		class_1264.method_66221(state, world, pos);
	}

	@Override
	protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
		return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
	}

	@Override
	protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
		return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, POWERED, PROGRESS);
	}
}
