package net.nml.bubble.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import net.minecraft.class_9848;
import net.nml.bubble.BubbleEntity;
import net.nml.bubble.ModRegistry;

public record BubbleWandEffectsComponent(Optional<Integer> color, Optional<Boolean> rainbow) implements class_9299 {
	public static final Codec<BubbleWandEffectsComponent> CODEC = RecordCodecBuilder.create(builder -> {
		return builder.group(
			Codec.INT.lenientOptionalFieldOf("color").forGetter(BubbleWandEffectsComponent::color),
			Codec.BOOL.lenientOptionalFieldOf("rainbow").forGetter(BubbleWandEffectsComponent::rainbow)
		).apply(builder, BubbleWandEffectsComponent::new);
	});
	public static final class_9139<class_9129, BubbleWandEffectsComponent> PACKET_CODEC = class_9139.method_56435(
		class_9135.method_56382(class_9135.field_49675), BubbleWandEffectsComponent::color,
		class_9135.method_56382(class_9135.field_48547), BubbleWandEffectsComponent::rainbow,
		BubbleWandEffectsComponent::new
	);

	public static Optional<Integer> getColor(class_1799 stack) {
		BubbleWandEffectsComponent bubbleWandEffectsComponent = stack.method_58694(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT);
		return bubbleWandEffectsComponent != null ? bubbleWandEffectsComponent.color() : Optional.empty();
	}

	public static boolean getRainbow(class_1799 stack) {
		BubbleWandEffectsComponent bubbleWandEffectsComponent = stack.method_58694(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT);
		return bubbleWandEffectsComponent != null ? bubbleWandEffectsComponent.rainbow().orElse(false) : false;
	}

	public static class_1799 setRainbow(class_1799 stack) {
		class_1799 itemStack = stack.method_46651(1);
		itemStack.method_57379(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT, new BubbleWandEffectsComponent(Optional.empty(), Optional.of(true)));
		return itemStack;
	}
	
	public static class_1799 setColor(class_1799 stack, List<class_1769> dyes) {
		if (!stack.method_31574(ModRegistry.BUBBLE_WAND)) {
			return class_1799.field_8037;
		} else {
			class_1799 itemStack = stack.method_46651(1);
			int i = 0;
			int j = 0;
			int k = 0;
			int l = 0;
			int m = 0;
			BubbleWandEffectsComponent dyedColorComponent = itemStack.method_58694(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT);
			if (dyedColorComponent != null && dyedColorComponent.color().isPresent()) {
				int n = class_9848.method_61327(dyedColorComponent.color().get());
				int o = class_9848.method_61329(dyedColorComponent.color().get());
				int p = class_9848.method_61331(dyedColorComponent.color().get());
				l += Math.max(n, Math.max(o, p));
				i += n;
				j += o;
				k += p;
				m++;
			}

			for (class_1769 dyeItem : dyes) {
				int p = dyeItem.method_7802().method_7787();
				int q = class_9848.method_61327(p);
				int r = class_9848.method_61329(p);
				int s = class_9848.method_61331(p);
				l += Math.max(q, Math.max(r, s));
				i += q;
				j += r;
				k += s;
				m++;
			}

			int n = i / m;
			int o = j / m;
			int p = k / m;
			float f = (float)l / m;
			float g = Math.max(n, Math.max(o, p));
			n = (int)(n * f / g);
			o = (int)(o * f / g);
			p = (int)(p * f / g);
			int s = class_9848.method_61324(0, n, o, p);
			itemStack.method_57379(ModRegistry.BUBBLE_WAND_EFFECTS_COMPONENT, new BubbleWandEffectsComponent(Optional.of(s), Optional.empty()));
			return itemStack;
		}
	}
	
	@Override
	public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
		if (this.color.isPresent() || this.rainbow.isPresent()) {
			int color = this.color.isPresent() ? this.color.get() : BubbleEntity.rainbowColor((float)(System.currentTimeMillis() % 36000)); // lol
			if (type.method_8035()) {
				if (this.color.isPresent()) {
					textConsumer.accept(class_2561.method_43469("item.color", String.format(Locale.ROOT, "#%06X", color)).method_54663(color));
				} else {
					textConsumer.accept(class_2561.method_43471("item.blowing-bubbles.bubble_wand.rainbow").method_54663(color));
				}
			} else {
				textConsumer.accept(class_2561.method_43471("item.dyed").method_27692(class_124.field_1056).method_54663(color));
			}
		}
	}
}
