package net.nml.bubble.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.nml.bubble.BubbleEntity;
import net.nml.bubble.LivingEntityRendererStateI;

@Mixin(class_922.class)
public abstract class LivingEntityRendererMixin {
	@Inject(method = "updateRenderState(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;F)V", at = @At("HEAD")) 
	public void updateRenderState(class_1309 entity, class_10042 state, float f, CallbackInfo ci) {
		if (state instanceof LivingEntityRendererStateI stateI) {
			stateI.setInBubble(entity.method_5854() instanceof BubbleEntity && !(entity instanceof BubbleEntity));
		}
	}

	@Inject(method = "setupTransforms(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;FF)V", at = @At("RETURN"))
	public void onSetupTransforms(class_10042 state, class_4587 matrices, float bodyYaw, float baseHeight, CallbackInfo ci) {
		if (state instanceof LivingEntityRendererStateI stateI && stateI.getInBubble()) {
			float time = state.field_53328 / 20.0f;
			float spinX = (float) (Math.sin(time) * 15f);
			float spinY = time * 40f;
			matrices.method_22907(class_7833.field_40714.rotationDegrees(spinX));
			matrices.method_22907(class_7833.field_40716.rotationDegrees(spinY));
			matrices.method_22904(0.0, -state.field_53330 / 2f, 0.0);
		}
	}
}
