/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.core.util;

import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class Helper {
    public static void causeMagicExplosionAttack(Level level, LivingEntity user, LivingEntity victim, float damageAmount, float distance) {
        DamageSource magicExplosion = level.damageSources().explosion((Entity)user, (Entity)user);
        for (LivingEntity nearbyEntity : Helper.getAoeTargets(victim, user, distance)) {
            nearbyEntity.hurt(magicExplosion, damageAmount);
        }
    }

    private static List<LivingEntity> getAoeTargets(LivingEntity center, LivingEntity attacker, float distance) {
        return center.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, new AABB(center.blockPosition()).inflate((double)distance), nearbyEntity -> Helper.isAoeTarget(nearbyEntity, attacker, center));
    }

    private static boolean isAoeTarget(LivingEntity self, LivingEntity attacker, LivingEntity center) {
        return self != attacker && self.isAlive() && !Helper.isAllOf(attacker, self) && !Helper.isUnaffected(self) && center.hasLineOfSight((Entity)self);
    }

    public static boolean isAllOf(LivingEntity self, LivingEntity other) {
        return self.isAlliedTo((Entity)other) || Helper.excludeFromDamge(other);
    }

    public static boolean excludeFromDamge(LivingEntity nearbyEntity) {
        return nearbyEntity instanceof Villager || nearbyEntity instanceof Allay || nearbyEntity instanceof Wolf && ((Wolf)nearbyEntity).isTame() || nearbyEntity instanceof AbstractHorse && ((AbstractHorse)nearbyEntity).isTamed() || nearbyEntity instanceof Parrot && ((Parrot)nearbyEntity).isTame() || nearbyEntity instanceof Cat && ((Cat)nearbyEntity).isTame();
    }

    private static boolean isUnaffected(LivingEntity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isCreative();
        }
        return false;
    }
}

