/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.core.item.custom;

import java.util.HashSet;
import java.util.List;
import net.anvian.anvianslib.util.TimeUtil;
import net.anvian.sculkhornid.core.config.ModConfigs;
import net.anvian.sculkhornid.core.item.custom.SculkHorn;
import net.anvian.sculkhornid.core.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SculkHornDistance
extends SculkHorn {
    public SculkHornDistance(ModConfigs.SculkHornConfig config, Item.Properties properties) {
        super(config, properties, (float)config.distanceDamage, TimeUtil.secondsToTicks((float)((float)config.distanceCooldown)), config.distanceExperienceLevel, config.distanceRemoveExperience);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (Screen.m_96638_()) {
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(Math.abs(this.REMOVE_EXPERIENCE))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.experience")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(this.config.distanceDistance)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.distance")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(TimeUtil.ticksToSeconds((int)this.COOLDOWN))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.cooldown")).m_130940_(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.m_237119_().m_130946_(String.valueOf(this.DAMAGE)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.damage")).m_130940_(ChatFormatting.DARK_GREEN));
        } else {
            list.add(Math.min(1, list.size()), (Component)Component.m_237115_((String)"tooltip_info_item.sculkhorn_shif"));
        }
        list.add(Math.min(1, list.size()), (Component)Component.m_237119_());
        list.add(Math.min(1, list.size()), (Component)Component.m_237115_((String)"tootip_sculkhorn_distance"));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (player.f_36078_ >= this.EXPERIENCE_LEVEL || player.m_7500_()) {
            player.m_6672_(interactionHand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack itemStack) {
        return this.config.distanceUseTime;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack itemStack, int i) {
        super.m_5929_(level, entity, itemStack, i);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        InteractionHand interactionHand = user.m_7655_();
        if (!level.f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            if (player.f_36078_ >= this.EXPERIENCE_LEVEL || player.m_7500_()) {
                if (!player.m_7500_()) {
                    player.m_6756_(this.REMOVE_EXPERIENCE);
                    stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(interactionHand));
                }
                if (this.config.bothInCooldown) {
                    this.applyCooldownToBothHorns(player);
                } else {
                    player.m_36335_().m_41524_((Item)this, this.COOLDOWN);
                }
                this.spawnSonicBoom(level, user);
            }
        }
        return super.m_5922_(stack, level, user);
    }

    private void spawnSonicBoom(Level level, LivingEntity user) {
        level.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 3.0f, 1.0f);
        Vec3 target = user.m_20182_().m_82549_(user.m_20154_().m_82490_((double)this.config.distanceDistance));
        Vec3 source = user.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalized = offSetToTarget.m_82541_();
        HashSet hit = new HashSet();
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()) + 7; ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalized.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            hit.addAll(level.m_6443_(LivingEntity.class, new AABB(new BlockPos((int)particlePos.f_82479_, (int)particlePos.f_82480_, (int)particlePos.f_82481_)).m_82400_(2.0), it -> !Helper.isAllOf(user, it)));
            hit.remove(user);
            for (Entity hitTarget : hit) {
                if (!(hitTarget instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)hitTarget;
                living.m_6469_(level.m_269111_().m_269285_((Entity)user), this.DAMAGE);
            }
        }
    }
}

