/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.core.item.custom;

import java.util.List;
import net.anvian.anvianslib.util.TimeUtil;
import net.anvian.sculkhornid.core.config.ModConfigs;
import net.anvian.sculkhornid.core.item.custom.SculkHorn;
import net.anvian.sculkhornid.core.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SculkHornArea
extends SculkHorn {
    public SculkHornArea(ModConfigs.SculkHornConfig config, Item.Properties properties) {
        super(config, properties, (float)config.areaDamage, TimeUtil.secondsToTicks((float)((float)config.areaCooldown)), config.areaExperienceLevel, config.areaRemoveExperience);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            list.add(Math.min(1, list.size()), (Component)Component.empty().append(String.valueOf(this.config.areaRadius)).append(" ").append((Component)Component.translatable((String)"tooltip.radius")).withStyle(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.empty().append(String.valueOf(TimeUtil.ticksToSeconds((int)this.COOLDOWN))).append(" ").append((Component)Component.translatable((String)"tooltip.cooldown")).withStyle(ChatFormatting.DARK_GREEN));
            list.add(Math.min(1, list.size()), (Component)Component.empty().append(String.valueOf(this.DAMAGE)).append(" ").append((Component)Component.translatable((String)"tooltip.damage")).withStyle(ChatFormatting.DARK_GREEN));
        } else {
            list.add(Math.min(1, list.size()), (Component)Component.translatable((String)"tooltip_info_item.sculkhorn_shif"));
        }
        list.add(Math.min(1, list.size()), (Component)Component.empty());
        list.add(Math.min(1, list.size()), (Component)Component.translatable((String)"tootip_sculkhorn_area"));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (!level.isClientSide && (player.experienceLevel >= this.EXPERIENCE_LEVEL || player.isCreative())) {
            if (!player.isCreative()) {
                player.giveExperiencePoints(this.REMOVE_EXPERIENCE);
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
            SculkHornArea.sonicBoom((LivingEntity)player, (LivingEntity)player, (float)this.config.areaRadius);
            Helper.causeMagicExplosionAttack(level, (LivingEntity)player, (LivingEntity)player, this.DAMAGE, (float)this.config.areaRadius);
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, this.config.areaSpeedDuration, this.config.areaSpeedAmplifier));
            if (this.config.bothInCooldown) {
                this.applyCooldownToBothHorns(player);
            } else {
                player.getCooldowns().addCooldown((Item)this, this.COOLDOWN);
            }
        }
        if (level.isClientSide && (player.experienceLevel >= this.EXPERIENCE_LEVEL || player.isCreative())) {
            level.playSound(player, (Entity)player, SoundEvents.WARDEN_SONIC_BOOM, SoundSource.RECORDS, 1.0f, 1.0f);
        }
        if (player.experienceLevel < this.EXPERIENCE_LEVEL && !player.isCreative()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    private static void sonicBoom(LivingEntity attacker, LivingEntity victim, float radius) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(victim.level(), victim.getX(), victim.getY() + 0.25, victim.getZ());
        areaEffectCloud.setOwner(attacker);
        areaEffectCloud.setParticle((ParticleOptions)ParticleTypes.SONIC_BOOM);
        areaEffectCloud.setRadius(radius);
        areaEffectCloud.setDuration(0);
        attacker.level().addFreshEntity((Entity)areaEffectCloud);
    }
}

