/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.core.item.custom;

import java.util.HashSet;
import java.util.function.Consumer;
import net.anvian.sculkhornid.core.config.ModConfigs;
import net.anvian.sculkhornid.core.item.custom.SculkHorn;
import net.anvian.sculkhornid.core.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SculkHornDistance
extends SculkHorn {
    public SculkHornDistance(ModConfigs.SculkHornConfig config, Item.Properties properties) {
        super(config, properties, (float)config.distanceDamage, (float)config.distanceCooldown, config.distanceExperienceLevel, config.distanceRemoveExperience);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            componentConsumer.accept((Component)Component.empty().append(String.valueOf(Math.abs(this.REMOVE_EXPERIENCE))).append(" ").append((Component)Component.translatable((String)"tooltip.experience")).withStyle(ChatFormatting.DARK_GREEN));
            componentConsumer.accept((Component)Component.empty().append(String.valueOf(this.config.distanceDistance)).append(" ").append((Component)Component.translatable((String)"tooltip.distance")).withStyle(ChatFormatting.DARK_GREEN));
            componentConsumer.accept((Component)Component.empty().append(String.valueOf(this.COOLDOWN)).append(" ").append((Component)Component.translatable((String)"tooltip.cooldown")).withStyle(ChatFormatting.DARK_GREEN));
            componentConsumer.accept((Component)Component.empty().append(String.valueOf(this.DAMAGE)).append(" ").append((Component)Component.translatable((String)"tooltip.damage")).withStyle(ChatFormatting.DARK_GREEN));
        } else {
            componentConsumer.accept((Component)Component.translatable((String)"tooltip_info_item.sculkhorn_shif"));
        }
        componentConsumer.accept((Component)Component.empty());
        componentConsumer.accept((Component)Component.translatable((String)"tootip_sculkhorn_distance"));
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player.experienceLevel >= this.EXPERIENCE_LEVEL || player.isCreative()) {
            player.startUsingItem(hand);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return this.config.distanceUseTime;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack itemStack, int i) {
        super.onUseTick(level, entity, itemStack, i);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide) {
            UseCooldown usecooldown = (UseCooldown)stack.get(DataComponents.USE_COOLDOWN);
            if (user instanceof Player) {
                Player player = (Player)user;
                if (player.experienceLevel >= this.EXPERIENCE_LEVEL || player.isCreative()) {
                    if (!player.isCreative()) {
                        player.giveExperiencePoints(this.REMOVE_EXPERIENCE);
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    }
                    if (this.config.bothInCooldown) {
                        this.applyCooldownToBothHorns(player);
                    } else if (usecooldown != null) {
                        usecooldown.apply(stack, (LivingEntity)player);
                    }
                    this.spawnSonicBoom(level, user);
                }
            }
        }
        return super.finishUsingItem(stack, level, user);
    }

    private void spawnSonicBoom(Level level, LivingEntity user) {
        level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 3.0f, 1.0f);
        Vec3 target = user.position().add(user.getLookAngle().scale((double)this.config.distanceDistance));
        Vec3 source = user.position().add(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.subtract(source);
        Vec3 normalized = offSetToTarget.normalize();
        HashSet hit = new HashSet();
        for (int particleIndex = 1; particleIndex < Mth.floor((double)offSetToTarget.length()) + 7; ++particleIndex) {
            Vec3 particlePos = source.add(normalized.scale((double)particleIndex));
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
            hit.addAll(level.getEntitiesOfClass(LivingEntity.class, new AABB(new BlockPos((int)particlePos.x, (int)particlePos.y, (int)particlePos.z)).inflate(2.0), it -> !Helper.isAllOf(user, it)));
            hit.remove(user);
            for (Entity hitTarget : hit) {
                if (!(hitTarget instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)hitTarget;
                living.hurt(level.damageSources().sonicBoom((Entity)user), this.DAMAGE);
            }
        }
    }
}

