/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import java.util.concurrent.atomic.AtomicReference;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.ScrollBarComponent;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableFrame
extends AbstractFrame {
    protected final Dim2i frameOrigin;
    protected final AbstractFrame frame;
    private boolean canScrollHorizontal;
    private boolean canScrollVertical;
    private Dim2i viewPortDimension = null;
    private ScrollBarComponent verticalScrollBar = null;
    private ScrollBarComponent horizontalScrollBar = null;

    public ScrollableFrame(Dim2i dim, AbstractFrame frame, boolean renderOutline, AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        super(dim, renderOutline);
        this.frame = frame;
        this.frameOrigin = new Dim2i(frame.dim.x(), frame.dim.y(), 0, 0);
        this.setupFrame(verticalScrollBarOffset, horizontalScrollBarOffset);
        this.buildFrame();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setupFrame(AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        if (!((Dim2iExtended)this.dim).canFitDimension(this.frame.dim)) {
            int value;
            if (this.dim.getLimitX() < this.frame.dim.getLimitX() && maxWidth < (value = this.frame.dim.x() - this.dim.x() + this.frame.dim.width())) {
                maxWidth = value;
            }
            if (this.dim.getLimitY() < this.frame.dim.getLimitY() && maxHeight < (value = this.frame.dim.y() - this.dim.y() + this.frame.dim.height())) {
                maxHeight = value;
            }
        }
        if (maxWidth > 0) {
            this.canScrollHorizontal = true;
        }
        if (maxHeight > 0) {
            this.canScrollVertical = true;
        }
        if (this.canScrollHorizontal && this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height() - 11);
        } else if (this.canScrollHorizontal) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height() - 11);
            ((Dim2iExtended)this.frame.dim).setHeight(this.frame.dim.height() - 11);
        } else if (this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height());
            ((Dim2iExtended)this.frame.dim).setWidth(this.frame.dim.width() - 11);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.x(), this.viewPortDimension.getLimitY() + 1, this.viewPortDimension.width(), 10), ScrollBarComponent.ScrollDirection.HORIZONTAL, this.frame.dim.width(), this.viewPortDimension.width(), offset -> {
                ((Dim2iExtended)this.frame.dim).setX(this.frameOrigin.x() - this.horizontalScrollBar.getOffset());
                horizontalScrollBarOffset.set((Integer)offset);
            });
            this.horizontalScrollBar.setOffset(horizontalScrollBarOffset.get());
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.getLimitX() + 1, this.viewPortDimension.y(), 10, this.viewPortDimension.height()), ScrollBarComponent.ScrollDirection.VERTICAL, this.frame.dim.height(), this.viewPortDimension.height(), offset -> {
                ((Dim2iExtended)this.frame.dim).setY(this.frameOrigin.y() - this.verticalScrollBar.getOffset());
                verticalScrollBarOffset.set((Integer)offset);
            }, this.viewPortDimension);
            this.verticalScrollBar.setOffset(verticalScrollBarOffset.get());
        }
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.controlElements.clear();
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.updateThumbLocation();
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.updateThumbLocation();
        }
        if (this.canScrollHorizontal) {
            ((Dim2iExtended)this.frame.dim).setX(this.frameOrigin.x() - this.horizontalScrollBar.getOffset());
            this.children.add(this.horizontalScrollBar);
        }
        if (this.canScrollVertical) {
            ((Dim2iExtended)this.frame.dim).setY(this.frameOrigin.y() - this.verticalScrollBar.getOffset());
            this.children.add(this.verticalScrollBar);
        }
        this.frame.buildFrame();
        this.children.add(this.frame);
        super.buildFrame();
        this.frame.registerFocusListener(element -> {
            if (element instanceof ControlElement) {
                ControlElement controlElement = (ControlElement)element;
                if (this.canScrollVertical) {
                    Dim2i dim = controlElement.getDimensions();
                    int inputOffset = this.verticalScrollBar.getOffset();
                    if (dim.y() <= this.viewPortDimension.y()) {
                        inputOffset += dim.y() - this.viewPortDimension.y();
                    } else if (dim.getLimitY() >= this.viewPortDimension.getLimitY()) {
                        inputOffset += dim.getLimitY() - this.viewPortDimension.getLimitY();
                    }
                    this.verticalScrollBar.setOffset(inputOffset);
                }
            }
        });
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.canScrollHorizontal || this.canScrollVertical) {
            if (this.renderOutline) {
                this.drawBorder(guiGraphics, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
            }
            this.applyScissor(guiGraphics, this.viewPortDimension.x(), this.viewPortDimension.y(), this.viewPortDimension.width(), this.viewPortDimension.height(), () -> super.method_25394(guiGraphics, mouseX, mouseY, delta));
        } else {
            super.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    @Nullable
    public class_8016 method_48205(@NotNull class_8023 navigation) {
        return super.method_48205(navigation);
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        return super.method_25402(event, bl) || this.canScrollHorizontal && this.horizontalScrollBar.method_25402(event, bl) || this.canScrollVertical && this.verticalScrollBar.method_25402(event, bl);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        return super.method_25403(event, deltaX, deltaY) || this.canScrollHorizontal && this.horizontalScrollBar.method_25403(event, deltaX, deltaY) || this.canScrollVertical && this.verticalScrollBar.method_25403(event, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 event) {
        return super.method_25406(event) || this.canScrollHorizontal && this.horizontalScrollBar.method_25406(event) || this.canScrollVertical && this.verticalScrollBar.method_25406(event);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount) || this.canScrollHorizontal && this.horizontalScrollBar.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount) || this.canScrollVertical && this.verticalScrollBar.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public static class Builder {
        private boolean renderOutline = false;
        private Dim2i dim = null;
        private AbstractFrame frame = null;
        private AtomicReference<Integer> verticalScrollBarOffset = new AtomicReference<Integer>(0);
        private AtomicReference<Integer> horizontalScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder withDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder withRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder withVerticalScrollBarOffset(AtomicReference<Integer> verticalScrollBarOffset) {
            this.verticalScrollBarOffset = verticalScrollBarOffset;
            return this;
        }

        public Builder withHorizontalScrollBarOffset(AtomicReference<Integer> horizontalScrollBarOffset) {
            this.horizontalScrollBarOffset = horizontalScrollBarOffset;
            return this;
        }

        public Builder withFrame(AbstractFrame frame) {
            this.frame = frame;
            return this;
        }

        public ScrollableFrame build() {
            return new ScrollableFrame(this.dim, this.frame, this.renderOutline, this.verticalScrollBarOffset, this.horizontalScrollBarOffset);
        }
    }
}

