/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.SearchTextFieldComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import me.flashyreese.mods.reeses_sodium_options.compat.IrisCompat;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.data.fingerprint.HashedFingerprint;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPrompt;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPromptable;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.VideoSettingsScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SodiumVideoOptionsScreen
extends Screen
implements ScreenPromptable {
    private static final AtomicReference<Component> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<String> lastSearch = new AtomicReference<String>("");
    private static final AtomicReference<Integer> lastSearchIndex = new AtomicReference<Integer>(0);
    private final Screen prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private SearchTextFieldComponent searchTextField;
    @Nullable
    private ScreenPrompt prompt;
    private static final List<FormattedText> DONATION_PROMPT_MESSAGE = List.of(FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"Hello!")}), FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"It seems that you've been enjoying "), Component.literal((String)"Sodium").withColor(2616210), Component.literal((String)", the free and open-source optimization mod for Minecraft.")}), FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"Mods like these are complex. They require "), Component.literal((String)"thousands of hours").withColor(16739840), Component.literal((String)" of development, debugging, and tuning to create the experience that players have come to expect.")}), FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"If you'd like to show your token of appreciation, and support the development of our mod in the process, then consider "), Component.literal((String)"buying us a coffee").withColor(15550926), Component.literal((String)".")}), FormattedText.composite((FormattedText[])new FormattedText[]{Component.literal((String)"And thanks again for using our mod! We hope it helps you (and your computer.)")}));

    public SodiumVideoOptionsScreen(Screen prev, List<OptionPage> pages) {
        super((Component)Component.literal((String)"Reese's Sodium Menu"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
        this.checkPromptTimers();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt(options);
        }
    }

    private void openDonationPrompt(SodiumGameOptions options) {
        ScreenPrompt prompt = new ScreenPrompt((ScreenPromptable)this, DONATION_PROMPT_MESSAGE, 320, 190, new ScreenPrompt.Action((Component)Component.literal((String)"Buy us a coffee"), this::openDonationPage));
        prompt.setFocused(true);
        options.notifications.hasSeenDonationPrompt = true;
        try {
            SodiumGameOptions.writeToDisk((SodiumGameOptions)options);
        }
        catch (IOException e) {
            SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
        }
    }

    public void rebuildUI() {
        this.rebuildWidgets();
    }

    protected void init() {
        super.init();
        BasicFrame frame = this.parentFrameBuilder().build();
        this.addRenderableWidget((GuiEventListener)frame);
        this.searchTextField.setFocused(!lastSearch.get().trim().isEmpty());
        if (this.searchTextField.isFocused()) {
            this.setFocused((GuiEventListener)this.searchTextField);
        } else {
            this.setFocused((GuiEventListener)frame);
        }
        if (this.prompt != null) {
            this.prompt.init();
        }
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        Dim2i searchTextFieldDim;
        int newWidth = this.width;
        if ((double)((float)this.width / (float)this.height) > 1.77777777778) {
            newWidth = (int)((double)this.height * 1.77777777778);
        }
        Dim2i basicFrameDim = new Dim2i((this.width - newWidth) / 2, 0, newWidth, this.height);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.x() + basicFrameDim.width() / 20 / 2, basicFrameDim.y() + basicFrameDim.height() / 4 / 2, basicFrameDim.width() - basicFrameDim.width() / 20, basicFrameDim.height() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        MutableComponent donationText = Component.translatable((String)"sodium.options.buttons.donate");
        int donationTextWidth = this.minecraft.font.width((FormattedText)donationText);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 32 - donationTextWidth, tabFrameDim.y() - 26, 10 + donationTextWidth, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.y() - 26, 20, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, (Component)Component.translatable((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, (Component)Component.translatable((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, (Component)Component.translatable((String)"gui.done"), this::onClose);
        this.donateButton = new FlatButtonWidget(donateButtonDim, (Component)donationText, this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, (Component)Component.literal((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            searchTextFieldDim = new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width(), 20);
        } else {
            searchTextFieldDim = new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width() - (tabFrameDim.getLimitX() - donateButtonDim.x()) - 2, 20);
            basicFrameBuilder.addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton);
        }
        if (IrisCompat.isIrisPresent()) {
            int size = this.minecraft.font.width((FormattedText)Component.translatable((String)Objects.requireNonNull(IrisCompat.getIrisShaderPacksScreenLanguageKey())));
            Dim2i shaderPackButtonDim = !SodiumClientMod.options().notifications.hasClearedDonationButton ? new Dim2i(donateButtonDim.x() - 12 - size, tabFrameDim.y() - 26, 10 + size, 20) : new Dim2i(tabFrameDim.getLimitX() - size - 10, tabFrameDim.y() - 26, 10 + size, 20);
            searchTextFieldDim = new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width() - (tabFrameDim.getLimitX() - shaderPackButtonDim.x()) - 2, 20);
            FlatButtonWidget shaderPackButton = new FlatButtonWidget(shaderPackButtonDim, (Component)Component.translatable((String)IrisCompat.getIrisShaderPacksScreenLanguageKey()), () -> this.minecraft.setScreen(IrisCompat.getIrisShaderPacksScreen(this)));
            basicFrameBuilder.addChild(dim -> shaderPackButton);
        }
        this.searchTextField = new SearchTextFieldComponent(searchTextFieldDim, this.pages, tabFrameSelectedTab, tabFrameScrollBarOffset, optionPageScrollBarOffset, tabFrameDim.height(), this, lastSearch, lastSearchIndex);
        basicFrameBuilder.addChild(dim -> this.searchTextField);
        return basicFrameBuilder;
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.builder().withDimension(parentBasicFrameDim).withRenderOutline(false).addChild(parentDim -> TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(page -> !page.getGroups().isEmpty()).forEach(page -> tabs.add(Tab.builder().from((OptionPage)page, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build()).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.updateControls();
        super.render(guiGraphics, this.prompt != null ? -1 : mouseX, this.prompt != null ? -1 : mouseY, delta);
        if (this.prompt != null) {
            this.prompt.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumGameOptions.writeToDisk((SodiumGameOptions)options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.rebuildUI();
    }

    private void openDonationPage() {
        Util.getPlatform().openUri("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.getInstance();
        if (flags.contains(OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.levelRenderer.allChanged();
        }
        if (flags.contains(OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.updateMaxMipLevel(((Integer)client.options.mipmapLevels().get()).intValue());
            client.delayTextureReload();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean repeated) {
        if (this.prompt != null) {
            return this.prompt.mouseClicked(event, repeated);
        }
        return super.mouseClicked(event, repeated);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.prompt != null) {
            return this.prompt.keyPressed(event);
        }
        if (!(event.key() != 80 || (event.modifiers() & 1) == 0 || this.searchTextField != null && this.searchTextField.isFocused())) {
            Minecraft.getInstance().setScreen((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.getInstance(), Minecraft.getInstance().options));
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    public void onClose() {
        lastSearch.set("");
        lastSearchIndex.set(0);
        this.minecraft.setScreen(this.prevScreen);
    }

    public void setPrompt(@Nullable ScreenPrompt prompt) {
        this.prompt = prompt;
    }

    @Nullable
    public ScreenPrompt getPrompt() {
        return this.prompt;
    }

    public Dim2i getDimensions() {
        return new Dim2i(0, 0, this.width, this.height);
    }
}

