/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ScrollBarComponent
extends AbstractWidget {
    protected static final int SCROLL_STEP = 6;
    protected final Dim2i scrollBarArea;
    private final ScrollDirection mode;
    private final int contentLength;
    private final int visibleAreaLength;
    private final int maxContentOffset;
    private final Consumer<Integer> offsetChangeListener;
    private int offset = 0;
    private boolean isDragging;
    private Dim2i scrollThumb = null;
    private int scrollThumbClickOffset;
    private final Dim2i extraScrollArea;

    public ScrollBarComponent(Dim2i trackArea, ScrollDirection scrollDirection, int contentLength, int visibleAreaLength, Consumer<Integer> offsetChangeListener) {
        this(trackArea, scrollDirection, contentLength, visibleAreaLength, offsetChangeListener, null);
    }

    public ScrollBarComponent(Dim2i scrollBarArea, ScrollDirection scrollDirection, int contentLength, int visibleAreaLength, Consumer<Integer> offsetChangeListener, Dim2i extraScrollArea) {
        this.scrollBarArea = scrollBarArea;
        this.mode = scrollDirection;
        this.contentLength = contentLength;
        this.visibleAreaLength = visibleAreaLength;
        this.offsetChangeListener = offsetChangeListener;
        this.maxContentOffset = this.contentLength - this.visibleAreaLength;
        this.extraScrollArea = extraScrollArea;
        this.updateThumbLocation();
    }

    public void updateThumbLocation() {
        int trackSize = this.mode == ScrollDirection.VERTICAL ? this.scrollBarArea.height() : this.scrollBarArea.width() - 6;
        int scrollThumbLength = this.visibleAreaLength * trackSize / this.contentLength;
        int maximumScrollThumbOffset = this.visibleAreaLength - scrollThumbLength;
        int scrollThumbOffset = this.offset * maximumScrollThumbOffset / this.maxContentOffset;
        this.scrollThumb = new Dim2i(this.scrollBarArea.x() + 2 + (this.mode == ScrollDirection.HORIZONTAL ? scrollThumbOffset : 0), this.scrollBarArea.y() + 2 + (this.mode == ScrollDirection.VERTICAL ? scrollThumbOffset : 0), (this.mode == ScrollDirection.VERTICAL ? this.scrollBarArea.width() : scrollThumbLength) - 4, (this.mode == ScrollDirection.VERTICAL ? scrollThumbLength : this.scrollBarArea.height()) - 4);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawBorder(guiGraphics, this.scrollBarArea.x(), this.scrollBarArea.y(), this.scrollBarArea.getLimitX(), this.scrollBarArea.getLimitY(), -5592406);
        this.drawRect(guiGraphics, this.scrollThumb.x(), this.scrollThumb.y(), this.scrollThumb.getLimitX(), this.scrollThumb.getLimitY(), -5592406);
        if (this.isFocused()) {
            this.drawBorder(guiGraphics, this.scrollBarArea.x(), this.scrollBarArea.y(), this.scrollBarArea.getLimitX(), this.scrollBarArea.getLimitY(), -1);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.scrollBarArea.containsCursor(event.x(), event.y())) {
            if (this.scrollThumb.containsCursor(event.x(), event.y())) {
                this.scrollThumbClickOffset = (int)(this.mode == ScrollDirection.VERTICAL ? event.y() - (double)this.scrollThumb.getCenterY() : event.x() - (double)this.scrollThumb.getCenterX());
                this.isDragging = true;
            } else {
                int thumbLength = this.mode == ScrollDirection.VERTICAL ? this.scrollThumb.height() : this.scrollThumb.width();
                int trackLength = this.mode == ScrollDirection.VERTICAL ? this.scrollBarArea.height() : this.scrollBarArea.width();
                int value = (int)(((this.mode == ScrollDirection.VERTICAL ? event.y() - (double)this.scrollBarArea.y() : event.x() - (double)this.scrollBarArea.x()) - (double)thumbLength / 2.0) * (double)this.maxContentOffset / (double)(trackLength - thumbLength));
                this.setOffset(value);
                this.isDragging = false;
            }
            return true;
        }
        this.isDragging = false;
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (event.button() == 0) {
            this.isDragging = false;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        if (this.isDragging) {
            int thumbLength = this.mode == ScrollDirection.VERTICAL ? this.scrollThumb.height() : this.scrollThumb.width();
            int trackLength = this.mode == ScrollDirection.VERTICAL ? this.scrollBarArea.height() : this.scrollBarArea.width();
            int value = (int)(((this.mode == ScrollDirection.VERTICAL ? event.y() : event.x()) - (double)this.scrollThumbClickOffset - (double)(this.mode == ScrollDirection.VERTICAL ? this.scrollBarArea.y() : this.scrollBarArea.x()) - (double)thumbLength / 2.0) * (double)this.maxContentOffset / (double)(trackLength - thumbLength));
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.scrollBarArea.containsCursor(mouseX, mouseY) || this.extraScrollArea != null && this.extraScrollArea.containsCursor(mouseX, mouseY)) {
            this.setOffset(this.offset - (int)verticalAmount * 6);
            return true;
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = Mth.clamp((int)value, (int)0, (int)this.maxContentOffset);
        this.updateThumbLocation();
        this.offsetChangeListener.accept(this.offset);
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.scrollBarArea.x(), this.scrollBarArea.y(), this.scrollBarArea.width(), this.scrollBarArea.height());
    }

    public boolean keyPressed(KeyEvent event) {
        int newOffset;
        if (!this.isFocused()) {
            return false;
        }
        switch (event.key()) {
            case 265: {
                int n = this.getOffset() - 6;
                break;
            }
            case 264: {
                int n = this.getOffset() + 6;
                break;
            }
            case 263: {
                int n;
                if (this.mode == ScrollDirection.HORIZONTAL) {
                    n = this.getOffset() - 6;
                    break;
                }
                n = this.getOffset();
                break;
            }
            case 262: {
                int n;
                if (this.mode == ScrollDirection.HORIZONTAL) {
                    n = this.getOffset() + 6;
                    break;
                }
                n = this.getOffset();
                break;
            }
            default: {
                int n = newOffset = this.getOffset();
            }
        }
        if (newOffset != this.getOffset()) {
            this.setOffset(newOffset);
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double x, double y) {
        return this.scrollBarArea.containsCursor(x, y);
    }

    public static enum ScrollDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

