/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.misc.FrequencyOrderedCollection;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.smarterfarmers.FarmTaskDebugRenderer;
import net.mehvahdjukaar.smarterfarmers.FarmTaskLogic;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.mehvahdjukaar.smarterfarmers.integration.QuarkIntegration;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3852;
import net.minecraft.class_4099;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4217;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SFHarvestFarmland
extends class_4217 {
    public int plantTimer;
    public class_2338 aboveFarmlandPos = null;
    public class_1799 seedToHold = null;
    @VisibleForTesting
    public boolean active = false;
    @VisibleForTesting
    public List<Pair<class_2338, Action>> farmlandAround;
    @VisibleForTesting
    public long lastTriedToStart;

    protected boolean method_19564(class_3218 level, class_1646 owner) {
        this.lastTriedToStart = level.method_8510();
        if (!level.method_8450().method_8355(class_1928.field_19388)) {
            return false;
        }
        if (owner.method_7231().method_16924() != class_3852.field_17056) {
            return false;
        }
        this.farmlandAround = this.getValidFarmlandAround(level, owner);
        if (this.farmlandAround.isEmpty()) {
            return false;
        }
        Pair<class_2338, Action> chosen = this.farmlandAround.get(level.method_8409().method_43048(this.farmlandAround.size()));
        this.aboveFarmlandPos = (class_2338)chosen.getFirst();
        this.seedToHold = null;
        if (chosen.getSecond() == Action.PLANT) {
            class_1799 seed = this.getSeedToPlantAt(this.aboveFarmlandPos, level, owner);
            if (!seed.method_7960()) {
                this.seedToHold = seed;
            } else {
                this.farmlandAround.removeIf(e -> e.getSecond() == Action.PLANT);
                if (this.farmlandAround.isEmpty()) {
                    return false;
                }
                chosen = this.farmlandAround.get(level.method_8409().method_43048(this.farmlandAround.size()));
                this.aboveFarmlandPos = (class_2338)chosen.getFirst();
            }
        }
        return true;
    }

    private List<Pair<class_2338, Action>> getValidFarmlandAround(class_3218 level, class_1646 owner) {
        ArrayList<Pair<class_2338, Action>> validFarmland = new ArrayList<Pair<class_2338, Action>>();
        class_2338.class_2339 mutableBlockPos = owner.method_24515().method_25503();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    mutableBlockPos.method_10102(owner.method_23317() + (double)i, owner.method_23318() + (double)j, owner.method_23321() + (double)k);
                    Action actionForPos = this.getActionForPos((class_2338)mutableBlockPos, level);
                    if (actionForPos == null) continue;
                    validFarmland.add((Pair<class_2338, Action>)Pair.of((Object)new class_2338((class_2382)mutableBlockPos), (Object)((Object)actionForPos)));
                }
            }
        }
        return validFarmland;
    }

    protected class_1799 getSeedToPlantAt(class_2338 targetPos, class_3218 level, class_1646 villager) {
        FrequencyOrderedCollection blockAsItemAround = new FrequencyOrderedCollection();
        class_2338.class_2339 mutableBlockPos = targetPos.method_25503();
        boolean hasAirInNeighbor = false;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_1792 item;
                    if (x == 0 && z == 0) continue;
                    mutableBlockPos.method_10103(targetPos.method_10263() + x, targetPos.method_10264() + y, targetPos.method_10260() + z);
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                    if (!hasAirInNeighbor && y == 0 && Math.abs(x) + Math.abs(z) == 1) {
                        hasAirInNeighbor = blockState.method_26215();
                    }
                    if ((item = blockState.method_26204().method_8389()) == class_1802.field_8162) continue;
                    blockAsItemAround.add((Object)item);
                }
            }
        }
        class_1277 inventory = villager.method_35199();
        HashSet<class_1792> availableSeeds = new HashSet<class_1792>();
        HashMap<class_1792, class_1799> villagerSeedsInInventory = new HashMap<class_1792, class_1799>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            class_1792 it = itemStack.method_7909();
            if (itemStack.method_7960() || !SFPlatformStuff.isValidSeed(itemStack, villager)) continue;
            availableSeeds.add(it);
            villagerSeedsInInventory.put(it, itemStack);
        }
        if (availableSeeds.isEmpty()) {
            return class_1799.field_8037;
        }
        boolean failedForMelon = false;
        for (class_1792 item : blockAsItemAround) {
            if (!availableSeeds.contains(item)) continue;
            if (item.method_7854().method_31573(SmarterFarmers.STEM_SEEDS) && (targetPos.method_10263() + targetPos.method_10260()) % 2 == 0) {
                failedForMelon = true;
                continue;
            }
            return (class_1799)villagerSeedsInInventory.get(item);
        }
        if (failedForMelon) {
            return class_1799.field_8037;
        }
        return (class_1799)villagerSeedsInInventory.get(availableSeeds.iterator().next());
    }

    protected void method_20392(class_3218 level, class_1646 entity, long gameTime) {
        this.active = true;
        this.plantTimer = SmarterFarmers.TIME_TO_HARVEST.get();
        Preconditions.checkNotNull((Object)this.aboveFarmlandPos);
        entity.method_5673(class_1304.field_6173, this.seedToHold != null ? this.seedToHold.method_7972() : FarmTaskLogic.getHoe(entity));
        entity.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.aboveFarmlandPos));
        entity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4099(this.aboveFarmlandPos), 0.5f, 1));
        if (PlatHelper.getPhysicalSide() == PlatHelper.Side.CLIENT) {
            FarmTaskDebugRenderer.INSTANCE.trackTask(entity, this);
        }
    }

    protected void method_19566(class_3218 level, class_1646 entity, long gameTime) {
        this.active = false;
        entity.method_5673(class_1304.field_6173, class_1799.field_8037);
        entity.method_18868().method_18875(class_4140.field_18446);
        entity.method_18868().method_18875(class_4140.field_18445);
        this.aboveFarmlandPos = null;
        this.farmlandAround.clear();
    }

    @Nullable
    protected Action getActionForPos(class_2338 pos, class_3218 level) {
        class_2680 cropState = level.method_8320(pos);
        class_2680 farmState = level.method_8320(pos.method_10074());
        if (cropState.method_26164(SmarterFarmers.HARVEST_BLACKLIST)) {
            return null;
        }
        if (FarmTaskLogic.isFarmland(farmState)) {
            if (FarmTaskLogic.isCropMature(cropState, pos, (class_1937)level)) {
                return Action.HARVEST_AND_REPLANT;
            }
            if (cropState.method_26215()) {
                return Action.plantIfNoMelonsAround(pos, level);
            }
        }
        if (farmState.method_26164(SmarterFarmers.FARMER_TILLABLE)) {
            if (cropState.method_26164(SmarterFarmers.HARVEST_ON_TILLABLE_NO_REPLANT)) {
                return Action.HARVEST;
            }
            if (cropState.method_26164(SmarterFarmers.HARVEST_ON_TILLABLE)) {
                return Action.HARVEST_AND_REPLANT;
            }
            if (cropState.method_26215() && SmarterFarmers.PLANT_ON_TILLABLE.get().booleanValue()) {
                return Action.plantIfNoMelonsAround(pos, level);
            }
        }
        return null;
    }

    public void method_19565(class_3218 level, class_1646 villager, long tickCount) {
        if (!this.aboveFarmlandPos.method_19769((class_2374)villager.method_19538(), 2.0)) {
            return;
        }
        --this.plantTimer;
        if (this.plantTimer > 0) {
            return;
        }
        class_2680 targetState = level.method_8320(this.aboveFarmlandPos);
        class_2338 belowPos = this.aboveFarmlandPos.method_10074();
        class_1792 toReplace = class_1802.field_8162;
        if (!targetState.method_26215()) {
            if (targetState.method_26164(SmarterFarmers.HARVEST_ON_FARMLAND_SPECIAL) || targetState.method_26164(SmarterFarmers.HARVEST_ON_TILLABLE) || targetState.method_26164(SmarterFarmers.HARVEST_ON_TILLABLE_NO_REPLANT)) {
                level.method_8651(this.aboveFarmlandPos, true, (class_1297)villager);
                class_2680 below = level.method_8320(belowPos);
                if (SFPlatformStuff.tillBlock(below, belowPos, level)) {
                    level.method_8396(null, belowPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                }
                if (targetState.method_26164(SmarterFarmers.HARVEST_ON_TILLABLE_NO_REPLANT)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
            } else if (FarmTaskLogic.isCropMature(targetState, this.aboveFarmlandPos, (class_1937)level)) {
                if (SmarterFarmers.QUARK && QuarkIntegration.breakWithAutoReplant(level, this.aboveFarmlandPos, (class_1309)villager)) {
                    this.aboveFarmlandPos = null;
                    return;
                }
                toReplace = targetState.method_26204().method_8389();
                level.method_8651(this.aboveFarmlandPos, true, (class_1297)villager);
            }
        }
        class_2680 farmlandBlock = level.method_8320(belowPos);
        targetState = level.method_8320(this.aboveFarmlandPos);
        if (targetState.method_26215()) {
            if (FarmTaskLogic.isFarmland(farmlandBlock)) {
                this.replant(level, villager, toReplace);
            } else if (farmlandBlock.method_26164(SmarterFarmers.FARMER_TILLABLE) && SFPlatformStuff.tillBlock(farmlandBlock, belowPos, level)) {
                level.method_8396(null, belowPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                this.replant(level, villager, toReplace);
            }
        }
        this.aboveFarmlandPos = null;
    }

    private void replant(class_3218 level, class_1646 villager, class_1792 toReplace) {
        class_1799 itemToPlant = class_1799.field_8037;
        if (toReplace != class_1802.field_8162) {
            itemToPlant = this.findSameItem(villager.method_35199(), toReplace);
        }
        if (itemToPlant.method_7960()) {
            itemToPlant = this.getSeedToPlantAt(this.aboveFarmlandPos, level, villager);
        }
        if (!itemToPlant.method_7960()) {
            boolean success = false;
            if (SFPlatformStuff.trySpecialPlant(level, this.aboveFarmlandPos, itemToPlant, villager)) {
                success = true;
            } else {
                class_1792 class_17922 = itemToPlant.method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 blockItem = (class_1747)class_17922;
                    class_2680 toPlant = blockItem.method_7711().method_9564();
                    level.method_8652(this.aboveFarmlandPos, toPlant, 3);
                    success = true;
                }
            }
            if (success) {
                class_2680 placed = level.method_8320(this.aboveFarmlandPos);
                level.method_43276((class_6880)class_5712.field_28164, this.aboveFarmlandPos, class_5712.class_7397.method_43286((class_1297)villager, (class_2680)placed));
                level.method_43128(null, (double)this.aboveFarmlandPos.method_10263(), (double)this.aboveFarmlandPos.method_10264(), (double)this.aboveFarmlandPos.method_10260(), class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
                itemToPlant.method_7934(1);
            } else {
                SmarterFarmers.LOGGER.error("Failed to replant {} from item {}", (Object)toReplace, (Object)itemToPlant);
            }
        } else {
            SmarterFarmers.LOGGER.error("Failed to replant {}", (Object)toReplace);
        }
    }

    @NotNull
    private class_1799 findSameItem(class_1277 inventory, class_1792 toReplace) {
        if (toReplace != class_1802.field_8162 && toReplace instanceof class_1747) {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 is = inventory.method_5438(i);
                if (is.method_7909() != toReplace) continue;
                return is;
            }
        }
        return class_1799.field_8037;
    }

    protected boolean method_20394(class_3218 level, class_1646 entity, long gameTime) {
        return this.aboveFarmlandPos != null;
    }

    public static enum Action {
        HARVEST,
        HARVEST_AND_REPLANT,
        PLANT;


        @Nullable
        public static Action plantIfNoMelonsAround(class_2338 pos, class_3218 level) {
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 neighbor = pos.method_10093(dir);
                class_2680 neighborState = level.method_8320(neighbor);
                if (!(neighborState.method_26204() instanceof class_2513)) continue;
                boolean hasOtherSpace = false;
                for (class_2350 dir2 : class_2350.class_2353.field_11062) {
                    class_2338 neighbor2;
                    if (dir2 == dir.method_10153() || !level.method_8320(neighbor2 = neighbor.method_10093(dir2)).method_26215()) continue;
                    hasOtherSpace = true;
                    break;
                }
                if (hasOtherSpace) continue;
                return null;
            }
            return PLANT;
        }

        public boolean harvests() {
            return this == HARVEST || this == HARVEST_AND_REPLANT;
        }
    }
}

