/*
 * Decompiled with CFR 0.152.
 */
package uk.co.clovetwilight3.discordwhitelist;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordWhitelistPlugin
extends JavaPlugin {
    private Connection connection;
    private JDA jda;
    private boolean useMysql;
    private File dataFile;
    private Map<String, PlayerData> playerDataMap = new HashMap<String, PlayerData>();
    private Gson gson = new Gson();

    public void onEnable() {
        this.saveDefaultConfig();
        this.useMysql = this.getConfig().getBoolean("mysql.enabled", false);
        if (this.useMysql) {
            this.setupDatabase();
            this.getLogger().info("MySQL database enabled and configured.");
        } else {
            this.setupFileStorage();
            this.getLogger().info("File-based storage enabled. MySQL disabled.");
        }
        this.getLogger().info("WhitelistPlugin Enabling...");
        String token = this.getConfig().getString("discord.token");
        if (token == null || token.isEmpty()) {
            this.getLogger().severe("Discord token is not set in config.yml!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.jda = JDABuilder.createDefault(token).enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[0]).addEventListeners(new DiscordSlashCommandListener()).setAutoReconnect(true).build();
            this.jda.awaitReady();
            this.getLogger().info("Discord bot connected successfully!");
        }
        catch (InterruptedException e) {
            this.getLogger().severe("Failed to connect Discord bot: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        if (this.useMysql) {
            this.closeDatabaseConnection();
        } else {
            this.saveFileData();
        }
        if (this.jda != null) {
            this.jda.shutdown();
            try {
                if (!this.jda.awaitShutdown(10L, TimeUnit.SECONDS)) {
                    this.jda.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.getLogger().warning("Discord bot shutdown interrupted: " + e.getMessage());
                this.jda.shutdownNow();
            }
        }
        this.getLogger().info("WhitelistPlugin Disabled");
    }

    private void setupFileStorage() {
        this.dataFile = new File(this.getDataFolder(), "playerdata.json");
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.loadFileData();
    }

    private void loadFileData() {
        if (!this.dataFile.exists()) {
            return;
        }
        try {
            String json = Files.readString(this.dataFile.toPath());
            Type type = new TypeToken<Map<String, PlayerData>>(this){}.getType();
            Map loadedData = (Map)this.gson.fromJson(json, type);
            if (loadedData != null) {
                this.playerDataMap = loadedData;
            }
            this.getLogger().info("Loaded " + this.playerDataMap.size() + " player records from file.");
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to load player data from file: " + e.getMessage());
        }
    }

    private void saveFileData() {
        try {
            String json = this.gson.toJson(this.playerDataMap);
            try (FileWriter writer = new FileWriter(this.dataFile);){
                writer.write(json);
            }
            this.getLogger().info("Saved " + this.playerDataMap.size() + " player records to file.");
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to save player data to file: " + e.getMessage());
        }
    }

    private void setupDatabase() {
        String host = this.getConfig().getString("mysql.host");
        String database = this.getConfig().getString("mysql.database");
        String username = this.getConfig().getString("mysql.username");
        String password = this.getConfig().getString("mysql.password");
        int port = this.getConfig().getInt("mysql.port");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false";
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.getLogger().info("Connected to MySQL database!");
            this.initializeTables();
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not connect to MySQL database: " + e.getMessage());
            this.getLogger().info("Falling back to file-based storage...");
            this.useMysql = false;
            this.setupFileStorage();
        }
    }

    private void initializeTables() {
        String sql = "CREATE TABLE IF NOT EXISTS discord_whitelist (uuid VARCHAR(36) PRIMARY KEY,username VARCHAR(50) NOT NULL,discord_id VARCHAR(20) NOT NULL,discord_username VARCHAR(50) NOT NULL,linked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.execute();
            this.getLogger().info("Whitelist table initialized.");
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to initialize tables: " + e.getMessage());
        }
    }

    private void closeDatabaseConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.getLogger().info("Database connection closed.");
            }
            catch (SQLException e) {
                this.getLogger().warning("Failed to close database connection: " + e.getMessage());
            }
        }
    }

    private boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public Connection getDatabaseConnection() {
        if (this.useMysql && !this.isConnected()) {
            this.setupDatabase();
        }
        return this.connection;
    }

    private void storePlayerData(String uuid, String username, String discordId, String discordUsername) {
        block9: {
            if (this.useMysql) {
                try (PreparedStatement stmt = this.getDatabaseConnection().prepareStatement("REPLACE INTO discord_whitelist (uuid, discord_id, discord_username, username) VALUES (?, ?, ?, ?)");){
                    stmt.setString(1, uuid);
                    stmt.setString(2, discordId);
                    stmt.setString(3, discordUsername);
                    stmt.setString(4, username);
                    stmt.executeUpdate();
                    break block9;
                }
                catch (SQLException e) {
                    this.getLogger().warning("MySQL Error: " + e.getMessage());
                    throw new RuntimeException("Database error", e);
                }
            }
            this.playerDataMap.put(uuid, new PlayerData(uuid, username, discordId, discordUsername));
            this.saveFileData();
        }
    }

    private void removePlayerData(String uuid) {
        block9: {
            if (this.useMysql) {
                try (PreparedStatement stmt = this.getDatabaseConnection().prepareStatement("DELETE FROM discord_whitelist WHERE uuid = ?");){
                    stmt.setString(1, uuid);
                    stmt.executeUpdate();
                    break block9;
                }
                catch (SQLException e) {
                    this.getLogger().warning("MySQL Error: " + e.getMessage());
                    throw new RuntimeException("Database error", e);
                }
            }
            this.playerDataMap.remove(uuid);
            this.saveFileData();
        }
    }

    private List<String> getUsernamesByDiscordId(String discordId) {
        ArrayList<String> usernames;
        block11: {
            usernames = new ArrayList<String>();
            if (this.useMysql) {
                try (PreparedStatement stmt = this.getDatabaseConnection().prepareStatement("SELECT username FROM discord_whitelist WHERE discord_id = ?");){
                    stmt.setString(1, discordId);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        usernames.add(rs.getString("username"));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    this.getLogger().warning("MySQL Error: " + e.getMessage());
                    throw new RuntimeException("Database error", e);
                }
            }
            for (PlayerData data : this.playerDataMap.values()) {
                if (!data.discordId.equals(discordId)) continue;
                usernames.add(data.username);
            }
        }
        return usernames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDiscordUsernameByMinecraftUsername(String username) {
        PlayerData data;
        if (this.useMysql) {
            try (PreparedStatement stmt = this.getDatabaseConnection().prepareStatement("SELECT discord_username FROM discord_whitelist WHERE username = ?");){
                stmt.setString(1, username);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) return null;
                String string = rs.getString("discord_username");
                return string;
            }
            catch (SQLException e) {
                this.getLogger().warning("MySQL Error: " + e.getMessage());
                throw new RuntimeException("Database error", e);
            }
        }
        Iterator<PlayerData> iterator2 = this.playerDataMap.values().iterator();
        do {
            if (!iterator2.hasNext()) return null;
            data = iterator2.next();
        } while (!data.username.equals(username));
        return data.discordUsername;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDiscordIdByUuid(String uuid) {
        if (this.useMysql) {
            try (PreparedStatement stmt = this.getDatabaseConnection().prepareStatement("SELECT discord_id FROM discord_whitelist WHERE uuid = ?");){
                stmt.setString(1, uuid);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) return null;
                String string = rs.getString("discord_id");
                return string;
            }
            catch (SQLException e) {
                this.getLogger().warning("MySQL Error: " + e.getMessage());
                throw new RuntimeException("Database error", e);
            }
        }
        PlayerData data = this.playerDataMap.get(uuid);
        if (data == null) return null;
        String string = data.discordId;
        return string;
    }

    public class DiscordSlashCommandListener
    extends ListenerAdapter {
        @Override
        public void onReady(ReadyEvent event) {
            event.getJDA().updateCommands().addCommands(Commands.slash("whitelist", "Add a player to the Minecraft server whitelist").addOption(OptionType.STRING, "player", "The Minecraft username to whitelist", true), Commands.slash("unwhitelist", "Remove a player from the Minecraft server whitelist").addOption(OptionType.STRING, "player", "The Minecraft username to remove from whitelist", true), Commands.slash("listwhitelist", "Display all players currently on the whitelist"), Commands.slash("whois", "Find which Minecraft accounts are linked to a Discord user").addOption(OptionType.USER, "user", "The Discord user to check", true), Commands.slash("whomc", "Find which Discord user is linked to a Minecraft username").addOption(OptionType.STRING, "username", "The Minecraft username to check", true), Commands.slash("storage", "Check the current storage method being used")).queue(success -> DiscordWhitelistPlugin.this.getLogger().info("Successfully registered slash commands!"), error -> DiscordWhitelistPlugin.this.getLogger().severe("Failed to register slash commands: " + error.getMessage()));
        }

        @Override
        public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
            switch (event.getName()) {
                case "whois": {
                    this.handleWhoisCommand(event);
                    break;
                }
                case "whomc": {
                    this.handleWhomcCommand(event);
                    break;
                }
                case "whitelist": {
                    this.handleWhitelistCommand(event);
                    break;
                }
                case "unwhitelist": {
                    this.handleUnwhitelistCommand(event);
                    break;
                }
                case "listwhitelist": {
                    this.handleListWhitelistCommand(event);
                    break;
                }
                case "storage": {
                    this.handleStorageCommand(event);
                }
            }
        }

        private void handleStorageCommand(SlashCommandInteractionEvent event) {
            String storageType = DiscordWhitelistPlugin.this.useMysql ? "MySQL Database" : "File-based Storage";
            String details = DiscordWhitelistPlugin.this.useMysql ? "Connected to: " + DiscordWhitelistPlugin.this.getConfig().getString("mysql.host") + ":" + DiscordWhitelistPlugin.this.getConfig().getInt("mysql.port") : "Data file: " + DiscordWhitelistPlugin.this.dataFile.getName() + " (" + DiscordWhitelistPlugin.this.playerDataMap.size() + " records)";
            event.reply("**Storage Information**\nType: " + storageType + "\nDetails: " + details).queue();
        }

        private void handleWhoisCommand(SlashCommandInteractionEvent event) {
            event.deferReply().queue();
            String discordId = event.getOption("user").getAsUser().getId();
            try {
                List<String> usernames = DiscordWhitelistPlugin.this.getUsernamesByDiscordId(discordId);
                StringBuilder response = new StringBuilder("Minecraft accounts linked to <@" + discordId + ">: ");
                if (!usernames.isEmpty()) {
                    response.append(String.join((CharSequence)", ", usernames));
                } else {
                    response.append("None");
                }
                event.getHook().sendMessage(response.toString()).queue();
            }
            catch (Exception e) {
                event.getHook().sendMessage("\u274c Failed to fetch data. Please try again later.").queue();
                DiscordWhitelistPlugin.this.getLogger().severe("Error in whois command: " + e.getMessage());
            }
        }

        private void handleWhomcCommand(SlashCommandInteractionEvent event) {
            event.deferReply().queue();
            String username = event.getOption("username").getAsString();
            try {
                String discordUsername = DiscordWhitelistPlugin.this.getDiscordUsernameByMinecraftUsername(username);
                if (discordUsername != null) {
                    event.getHook().sendMessage("**" + discordUsername + "** is linked to Minecraft username **" + username + "**").queue();
                } else {
                    event.getHook().sendMessage("\u274c No Discord user is linked to Minecraft username **" + username + "**").queue();
                }
            }
            catch (Exception e) {
                event.getHook().sendMessage("\u274c Failed to fetch data. Please try again later.").queue();
                DiscordWhitelistPlugin.this.getLogger().severe("Error in whomc command: " + e.getMessage());
            }
        }

        private void handleWhitelistCommand(SlashCommandInteractionEvent event) {
            event.deferReply().queue();
            String playerName = event.getOption("player").getAsString();
            String discordId = event.getUser().getId();
            String discordUsername = event.getUser().getAsTag();
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                    UUID uuid = player.getUniqueId();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("whitelist add " + playerName));
                    DiscordWhitelistPlugin.this.storePlayerData(uuid.toString(), playerName, discordId, discordUsername);
                    event.getHook().sendMessage("\u2705 Player **" + playerName + "** has been added to the whitelist!").queue();
                }
                catch (Exception e) {
                    DiscordWhitelistPlugin.this.getLogger().warning("Error adding player: " + e.getMessage());
                    event.getHook().sendMessage("\u274c Failed to add player to whitelist.").queue();
                }
            });
        }

        private void handleUnwhitelistCommand(SlashCommandInteractionEvent event) {
            event.deferReply().queue();
            String playerName = event.getOption("player").getAsString();
            String discordId = event.getUser().getId();
            String adminDiscordId = DiscordWhitelistPlugin.this.getConfig().getString("discord.admin_id");
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                    UUID uuid = player.getUniqueId();
                    String playerDiscordId = DiscordWhitelistPlugin.this.getDiscordIdByUuid(uuid.toString());
                    if (playerDiscordId != null && (playerDiscordId.equals(discordId) || discordId.equals(adminDiscordId))) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("whitelist remove " + playerName));
                        DiscordWhitelistPlugin.this.removePlayerData(uuid.toString());
                        event.getHook().sendMessage("\u2705 Player **" + playerName + "** has been removed from the whitelist.").queue();
                    } else {
                        event.getHook().sendMessage("\u274c You do not have permission to unwhitelist this player.").queue();
                    }
                }
                catch (Exception e) {
                    DiscordWhitelistPlugin.this.getLogger().warning("Error removing player: " + e.getMessage());
                    event.getHook().sendMessage("\u274c Failed to remove player from whitelist.").queue();
                }
            });
        }

        private void handleListWhitelistCommand(SlashCommandInteractionEvent event) {
            event.deferReply().queue();
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                StringBuilder response = new StringBuilder("**Whitelisted Players:**\n```\n");
                for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                    response.append("\u2022 ").append(player.getName()).append("\n");
                }
                if (response.toString().equals("**Whitelisted Players:**\n```\n")) {
                    response.append("No players are currently whitelisted.");
                }
                response.append("```");
                event.getHook().sendMessage(response.toString()).queue();
            });
        }
    }

    public static class PlayerData {
        public String uuid;
        public String username;
        public String discordId;
        public String discordUsername;
        public long linkedAt;

        public PlayerData(String uuid, String username, String discordId, String discordUsername) {
            this.uuid = uuid;
            this.username = username;
            this.discordId = discordId;
            this.discordUsername = discordUsername;
            this.linkedAt = System.currentTimeMillis();
        }
    }
}

