/*
 * Decompiled with CFR 0.152.
 */
package com.example.discordwhitelist;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordWhitelistPlugin
extends JavaPlugin {
    private Connection connection;
    private JDA jda;

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupDatabase();
        this.getLogger().info("WhitelistPlugin Enabling...");
        String token = this.getConfig().getString("discord.token");
        if (token == null || token.isEmpty()) {
            this.getLogger().severe("Discord token is not set in config.yml!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.jda = JDABuilder.createDefault(token).enableIntents(GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGES).addEventListeners(new DiscordListener()).setAutoReconnect(true).build();
            this.jda.awaitReady();
            this.getLogger().info("Discord bot connected successfully!");
        }
        catch (InterruptedException e) {
            this.getLogger().severe("Failed to connect Discord bot: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.closeDatabaseConnection();
        if (this.jda != null) {
            this.jda.shutdown();
            try {
                if (!this.jda.awaitShutdown(10L, TimeUnit.SECONDS)) {
                    this.jda.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.getLogger().warning("Discord bot shutdown interrupted: " + e.getMessage());
                this.jda.shutdownNow();
            }
        }
        this.getLogger().info("WhitelistPlugin Disabled");
    }

    private void setupDatabase() {
        String host = this.getConfig().getString("mysql.host");
        String database = this.getConfig().getString("mysql.database");
        String username = this.getConfig().getString("mysql.username");
        String password = this.getConfig().getString("mysql.password");
        int port = this.getConfig().getInt("mysql.port");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false";
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.getLogger().info("Connected to MySQL database!");
            this.initializeTables();
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not connect to MySQL database: " + e.getMessage());
        }
    }

    private void initializeTables() {
        String sql = "CREATE TABLE IF NOT EXISTS discord_whitelist (uuid VARCHAR(36) PRIMARY KEY,username VARCHAR(50) NOT NULL,discord_id VARCHAR(20) NOT NULL,discord_username VARCHAR(50) NOT NULL,linked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.execute();
            this.getLogger().info("Whitelist table initialized.");
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to initialize tables: " + e.getMessage());
        }
    }

    private void closeDatabaseConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.getLogger().info("Database connection closed.");
            }
            catch (SQLException e) {
                this.getLogger().warning("Failed to close database connection: " + e.getMessage());
            }
        }
    }

    private boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public Connection getDatabaseConnection() {
        if (!this.isConnected()) {
            this.setupDatabase();
        }
        return this.connection;
    }

    public class DiscordListener
    extends ListenerAdapter {
        @Override
        public void onMessageReceived(MessageReceivedEvent event) {
            if (event.getAuthor().isBot()) {
                return;
            }
            Message message = event.getMessage();
            String content = message.getContentRaw();
            if (content.startsWith("!whois")) {
                this.handleWhoisCommand(event, content);
            } else if (content.startsWith("!whomc")) {
                this.handleWhomcCommand(event, content);
            } else if (content.startsWith("!whitelist")) {
                this.handleWhitelistCommand(event, content);
            } else if (content.startsWith("!unwhitelist")) {
                this.handleUnwhitelistCommand(event, content);
            } else if (content.startsWith("!listwhitelist")) {
                this.handleListWhitelistCommand(event);
            }
        }

        private void handleWhoisCommand(MessageReceivedEvent event, String content) {
            String[] args2 = content.split(" ");
            if (args2.length != 2) {
                event.getChannel().sendMessage("Usage: !whois @DiscordUser").queue();
                return;
            }
            String discordId = args2[1].replaceAll("[^0-9]", "");
            try (PreparedStatement stmt = DiscordWhitelistPlugin.this.getDatabaseConnection().prepareStatement("SELECT username FROM discord_whitelist WHERE discord_id = ?");){
                stmt.setString(1, discordId);
                ResultSet rs = stmt.executeQuery();
                StringBuilder response = new StringBuilder("Minecraft accounts linked to <@" + discordId + ">: ");
                while (rs.next()) {
                    response.append(rs.getString("username")).append(", ");
                }
                if (response.toString().endsWith(", ")) {
                    response.setLength(response.length() - 2);
                } else {
                    response.append("None");
                }
                event.getChannel().sendMessage(response.toString()).queue();
            }
            catch (SQLException e) {
                event.getChannel().sendMessage("Failed to fetch data. Please try again later.").queue();
                DiscordWhitelistPlugin.this.getLogger().severe("MySQL Error: " + e.getMessage());
            }
        }

        private void handleWhomcCommand(MessageReceivedEvent event, String content) {
            String[] args2 = content.split(" ");
            if (args2.length != 2) {
                event.getChannel().sendMessage("Usage: !whomc <MinecraftUsername>").queue();
                return;
            }
            String username = args2[1];
            try (PreparedStatement stmt = DiscordWhitelistPlugin.this.getDatabaseConnection().prepareStatement("SELECT discord_username FROM discord_whitelist WHERE username = ?");){
                stmt.setString(1, username);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String discordUsername = rs.getString("discord_username");
                    event.getChannel().sendMessage("\"" + discordUsername + " is linked to Minecraft username " + username).queue();
                } else {
                    event.getChannel().sendMessage("No Discord user is linked to Minecraft username " + username).queue();
                }
            }
            catch (SQLException e) {
                event.getChannel().sendMessage("Failed to fetch data. Please try again later.").queue();
                DiscordWhitelistPlugin.this.getLogger().severe("MySQL Error: " + e.getMessage());
            }
        }

        private void handleWhitelistCommand(MessageReceivedEvent event, String content) {
            String[] args2 = content.split(" ");
            if (args2.length != 2) {
                event.getChannel().sendMessage("Usage: !whitelist <playerName>").queue();
                return;
            }
            String playerName = args2[1];
            String discordId = event.getAuthor().getId();
            String discordUsername = event.getAuthor().getAsTag();
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                    UUID uuid = player.getUniqueId();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("whitelist add " + playerName));
                    try (PreparedStatement stmt = DiscordWhitelistPlugin.this.getDatabaseConnection().prepareStatement("REPLACE INTO discord_whitelist (uuid, discord_id, discord_username, username) VALUES (?, ?, ?, ?)");){
                        stmt.setString(1, uuid.toString());
                        stmt.setString(2, discordId);
                        stmt.setString(3, discordUsername);
                        stmt.setString(4, playerName);
                        stmt.executeUpdate();
                    }
                    event.getChannel().sendMessage("Player " + playerName + " has been added to the whitelist!").queue();
                }
                catch (SQLException e) {
                    DiscordWhitelistPlugin.this.getLogger().warning("MySQL Error: " + e.getMessage());
                    event.getChannel().sendMessage("Failed to add player to whitelist.").queue();
                }
            });
        }

        private void handleUnwhitelistCommand(MessageReceivedEvent event, String content) {
            String[] args2 = content.split(" ");
            if (args2.length != 2) {
                event.getChannel().sendMessage("Usage: !unwhitelist <playerName>").queue();
                return;
            }
            String playerName = args2[1];
            String discordId = event.getAuthor().getId();
            String adminDiscordId = DiscordWhitelistPlugin.this.getConfig().getString("discord.admin_id");
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
                    UUID uuid = player.getUniqueId();
                    try (PreparedStatement stmt = DiscordWhitelistPlugin.this.getDatabaseConnection().prepareStatement("SELECT discord_id FROM discord_whitelist WHERE uuid = ?");){
                        stmt.setString(1, uuid.toString());
                        ResultSet rs = stmt.executeQuery();
                        if (rs.next() && (rs.getString("discord_id").equals(discordId) || discordId.equals(adminDiscordId))) {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("whitelist remove " + playerName));
                            event.getChannel().sendMessage("Player \"" + playerName + " has been removed from the whitelist.").queue();
                        } else {
                            event.getChannel().sendMessage("You do not have permission to unwhitelist this player.").queue();
                        }
                    }
                }
                catch (SQLException e) {
                    DiscordWhitelistPlugin.this.getLogger().warning("Error removing player: " + e.getMessage());
                }
            });
        }

        private void handleListWhitelistCommand(MessageReceivedEvent event) {
            Bukkit.getScheduler().runTask((Plugin)DiscordWhitelistPlugin.this, () -> {
                StringBuilder response = new StringBuilder("Whitelisted players:\n\"");
                for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                    response.append(player.getName()).append("\n");
                }
                if (response.toString().equals("Whitelisted players:\n")) {
                    response.append("No players are currently whitelisted.");
                }
                event.getChannel().sendMessage(response.toString()).queue();
            });
        }
    }
}

