/*
 * Decompiled with CFR 0.152.
 */
package com.ssgdada;

import com.ssgdada.VersionChecker;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HTMLPlugin
extends JavaPlugin {
    private HttpServer server;
    private int port;
    private String publicFolderPath;
    private String mainHtmlFileName;
    private boolean allowStaticResources;

    public void onEnable() {
        String serverVersion = VersionChecker.getServerVersion();
        if (!VersionChecker.isVersionSupported()) {
            this.getLogger().severe("Unsupported server version. This plugin supports 1.16 to 1.21.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Running on Minecraft version: " + serverVersion);
        this.loadConfig();
        this.createFileStructure();
        this.startHttpServer();
        this.getLogger().info("HTMLPlugin \u0437\u0430\u043f\u0443\u0449\u0435\u043d!");
    }

    public void onDisable() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.getLogger().info("HTMLPlugin \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.port = config.getInt("server-port", 8080);
        this.publicFolderPath = config.getString("public-folder", "public");
        this.mainHtmlFileName = config.getString("main-html-file", "index.html");
        this.allowStaticResources = config.getBoolean("allow-static-resources", true);
    }

    private void createFileStructure() {
        File cssFile;
        File pluginFolder = this.getDataFolder();
        File publicFolder = new File(pluginFolder, this.publicFolderPath);
        if (!publicFolder.exists()) {
            publicFolder.mkdirs();
        }
        new File(publicFolder, "videos").mkdir();
        new File(publicFolder, "photos").mkdir();
        new File(publicFolder, "documents").mkdir();
        File indexFile = new File(publicFolder, this.mainHtmlFileName);
        if (!indexFile.exists()) {
            try (OutputStream os = Files.newOutputStream(indexFile.toPath(), new OpenOption[0]);){
                os.write("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Welcome to HTMLPlugin</title>\n    <link rel=\"stylesheet\" href=\"/styles.css\">\n    <link href=\"https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap\" rel=\"stylesheet\">\n</head>\n<body>\n    <div class=\"container\">\n        <header>\n            <h1>Host your own websites directly in Minecraft hosting using our plugin!</h1>\n        </header>\n\n        <section class=\"about-plugin\">\n            <h2>What is HTMLPlugin?</h2>\n            <p>HTMLPlugin allows Minecraft server owners to run a custom website directly from their Minecraft server.\n               You can easily add and modify web pages within the <strong>public</strong> folder of the plugin, enabling\n               you to create your own landing pages, display server information, or even create something more.</p>\n        </section>\n\n        <section class=\"community-section\">\n            <h2>Creator HTMLPlugin</h2>\n            <ul>\n                <li><a href=\"https://t.me/ssgdada\" target=\"_blank\">Join our Telegram</a></li>\n                <li><a href=\"https://discord.gg/VqgFzvwJvq\" target=\"_blank\">Join our Discord</a></li>\n            </ul>\n        </section>\n\n        <footer>\n            <p>&copy; 2025 HTMLPlugin | Crafted with <span class=\"heart\">\u2665</span> for Minecraft</p>\n            <p>\u0410\u043c\u0435\u0440\u0438\u043a\u0430, \u0432\u0430\u0441\u0430\u043f.</p>\n        </footer>\n    </div>\n</body>\n</html>\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(cssFile = new File(publicFolder, "styles.css")).exists()) {
            try (OutputStream os = Files.newOutputStream(cssFile.toPath(), new OpenOption[0]);){
                os.write("* {\n    margin: 0;\n    padding: 0;\n    box-sizing: border-box;\n}\n\nbody {\n    font-family: 'Roboto', sans-serif;\n    background-color: #f4f4f9;\n    color: #333;\n    line-height: 1.6;\n    text-align: center;\n    padding: 0 20px;\n}\n\n.container {\n    max-width: 800px;\n    margin: 50px auto;\n    padding: 20px;\n    background-color: #fff;\n    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);\n    border-radius: 8px;\n}\n\nheader h1 {\n    font-size: 2.5rem;\n    color: #ff6600;\n    margin-bottom: 20px;\n}\n\nheader p {\n    font-size: 1.2rem;\n    color: #666;\n}\n\n.about-plugin {\n    margin: 40px 0;\n}\n\n.about-plugin h2 {\n    font-size: 2rem;\n    color: #333;\n    margin-bottom: 15px;\n}\n\n.about-plugin p {\n    font-size: 1.1rem;\n    color: #555;\n    line-height: 1.8;\n}\n\n.community-section {\n    margin-bottom: 40px;\n}\n\n.community-section h2 {\n    font-size: 2rem;\n    color: #333;\n    margin-bottom: 15px;\n}\n\n.community-section ul {\n    list-style: none;\n    padding: 0;\n    margin-top: 20px;\n}\n\n.community-section ul li {\n    margin: 15px 0;\n}\n\n.community-section a {\n    font-size: 1.2rem;\n    color: #0066ff;\n    text-decoration: none;\n    font-weight: 700;\n    transition: color 0.3s ease;\n}\n\n.community-section a:hover {\n    color: #ff6600;\n}\n\nfooter {\n    margin-top: 40px;\n    color: #888;\n}\n\nfooter .heart {\n    color: #ff6600;\n    font-size: 1.2rem;\n}\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void startHttpServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", exchange -> {
                File file;
                Object filePath = exchange.getRequestURI().getPath();
                if ("/".equals(filePath)) {
                    filePath = "/" + this.mainHtmlFileName;
                }
                if ((file = new File(this.getDataFolder(), this.publicFolderPath + (String)filePath)).exists() && file.isFile()) {
                    if (((String)filePath).equals("/" + this.mainHtmlFileName)) {
                        byte[] fileContent = Files.readAllBytes(file.toPath());
                        exchange.getResponseHeaders().set("Content-Type", "text/html");
                        exchange.sendResponseHeaders(200, fileContent.length);
                        exchange.getResponseBody().write(fileContent);
                    } else if (((String)filePath).endsWith(".css")) {
                        byte[] fileContent = Files.readAllBytes(file.toPath());
                        exchange.getResponseHeaders().set("Content-Type", "text/css");
                        exchange.sendResponseHeaders(200, fileContent.length);
                        exchange.getResponseBody().write(fileContent);
                    } else {
                        String errorMessage = "403 Forbidden: Access is denied.";
                        exchange.sendResponseHeaders(403, errorMessage.length());
                        exchange.getResponseBody().write(errorMessage.getBytes());
                    }
                } else {
                    String errorMessage = "404 Not Found: The requested file does not exist.";
                    exchange.sendResponseHeaders(404, errorMessage.length());
                    exchange.getResponseBody().write(errorMessage.getBytes());
                }
                exchange.getResponseBody().close();
            });
            this.server.setExecutor(null);
            this.server.start();
            this.getLogger().info("HTTP Server started on port " + this.port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

